/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.util;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.extension.io.grpc.source.AbstractGrpcSource;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class SourceServerInterceptor
implements ServerInterceptor {
    private static final Logger logger = Logger.getLogger((String)SourceServerInterceptor.class.getName());
    private SiddhiAppContext siddhiAppContext;
    private String streamID;

    public SourceServerInterceptor(SiddhiAppContext siddhiAppContext, String streamID) {
        this.siddhiAppContext = siddhiAppContext;
        this.streamID = streamID;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        logger.error((Object)("Interceptor thread is: " + Thread.currentThread().getId()));
        Set metadataKeys = metadata.keys();
        HashMap<String, Object> metaDataMap = new HashMap<String, Object>();
        for (String key : metadataKeys) {
            metaDataMap.put(key, metadata.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
        }
        AbstractGrpcSource.metaDataMap.set(metaDataMap);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.siddhiAppContext.getName() + ":" + this.streamID + ": Metadata received: " + ((Object)metaDataMap).toString()));
        }
        return Contexts.interceptCall((Context)Context.ROOT, serverCall, (Metadata)metadata, serverCallHandler);
    }
}

