/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.sink;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.transport.DynamicOptions;
import io.siddhi.core.util.transport.Option;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.grpc.util.ServiceConfigs;
import io.siddhi.query.api.definition.StreamDefinition;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.wso2.grpc.Event;

public abstract class AbstractGrpcSink
extends Sink {
    protected String siddhiAppName;
    protected ManagedChannel channel = null;
    protected String streamID;
    protected Option headersOption;
    protected Option metadataOption;
    protected ManagedChannelBuilder managedChannelBuilder;
    protected long channelTerminationWaitingTimeInMillis = -1L;
    protected ServiceConfigs serviceConfigs;
    protected StreamDefinition streamDefinition;
    protected Map<String, String> headersMap;

    public Class[] getSupportedInputEventClasses() {
        return new Class[]{GeneratedMessageV3.class, String.class};
    }

    protected ServiceDeploymentInfo exposeServiceDeploymentInfo() {
        return null;
    }

    public String[] getSupportedDynamicOptions() {
        return new String[]{"headers", "metadata"};
    }

    protected StateFactory init(StreamDefinition streamDefinition, OptionHolder optionHolder, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.siddhiAppName = siddhiAppContext.getName();
        this.streamID = streamDefinition.getId();
        this.streamDefinition = streamDefinition;
        if (optionHolder.isOptionExists("headers")) {
            this.headersOption = optionHolder.validateAndGetOption("headers");
        }
        if (optionHolder.isOptionExists("metadata")) {
            this.metadataOption = optionHolder.validateAndGetOption("metadata");
        }
        this.serviceConfigs = new ServiceConfigs(optionHolder, siddhiAppContext, this.streamID, configReader, false);
        this.managedChannelBuilder = NettyChannelBuilder.forTarget((String)this.serviceConfigs.getHostPort());
        if (this.serviceConfigs.getTruststoreFilePath() != null || this.serviceConfigs.getKeystoreFilePath() != null) {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (this.serviceConfigs.getTruststoreFilePath() != null) {
                sslContextBuilder.trustManager(this.getTrustManagerFactory(this.serviceConfigs.getTruststoreFilePath(), this.serviceConfigs.getTruststorePassword(), this.serviceConfigs.getTruststoreAlgorithm(), this.serviceConfigs.getTlsStoreType()));
            }
            if (this.serviceConfigs.getKeystoreFilePath() != null) {
                sslContextBuilder.keyManager(this.getKeyManagerFactory(this.serviceConfigs.getKeystoreFilePath(), this.serviceConfigs.getKeystorePassword(), this.serviceConfigs.getKeystoreAlgorithm(), this.serviceConfigs.getTlsStoreType()));
            }
            try {
                this.managedChannelBuilder = ((NettyChannelBuilder)this.managedChannelBuilder).sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new SiddhiAppCreationException(siddhiAppContext.getName() + ": " + this.streamID + ": Error while creating gRPC channel. " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.managedChannelBuilder = this.managedChannelBuilder.usePlaintext();
        }
        if (optionHolder.isOptionExists("idle.timeout")) {
            this.managedChannelBuilder.idleTimeout(Long.parseLong(optionHolder.validateAndGetOption("idle.timeout").getValue()), TimeUnit.MILLISECONDS);
        }
        if (optionHolder.isOptionExists("keep.alive.time")) {
            this.managedChannelBuilder.keepAliveTime(Long.parseLong(optionHolder.validateAndGetOption("keep.alive.time").getValue()), TimeUnit.MILLISECONDS);
        }
        if (optionHolder.isOptionExists("keep.alive.timeout")) {
            this.managedChannelBuilder.keepAliveTimeout(Long.parseLong(optionHolder.validateAndGetOption("keep.alive.timeout").getValue()), TimeUnit.MILLISECONDS);
        }
        if (optionHolder.isOptionExists("keep.alive.without.calls")) {
            this.managedChannelBuilder.keepAliveWithoutCalls(Boolean.parseBoolean(optionHolder.validateAndGetOption("keep.alive.without.calls").getValue()));
        }
        if (Boolean.parseBoolean(optionHolder.getOrCreateOption("enable.retry", "false").getValue())) {
            this.managedChannelBuilder.enableRetry();
            if (optionHolder.isOptionExists("max.retry.attempts")) {
                this.managedChannelBuilder.maxRetryAttempts(Integer.parseInt(optionHolder.validateAndGetOption("max.retry.attempts").getValue()));
            }
            if (optionHolder.isOptionExists("retry.buffer.size")) {
                this.managedChannelBuilder.retryBufferSize(Long.parseLong(optionHolder.validateAndGetOption("retry.buffer.size").getValue()));
            }
            if (optionHolder.isOptionExists("per.rpc.buffer.size")) {
                this.managedChannelBuilder.perRpcBufferLimit(Long.parseLong(optionHolder.validateAndGetOption("per.rpc.buffer.size").getValue()));
            }
        }
        this.initSink(optionHolder);
        if (this.headersOption != null && this.headersOption.isStatic()) {
            String[] headersArray;
            this.headersMap = new HashMap<String, String>();
            String headers = this.headersOption.getValue();
            headers = headers.replaceAll("'", "");
            for (String headerKeyValue : headersArray = headers.split(",")) {
                String[] headerKeyValueArray = headerKeyValue.split(":");
                this.headersMap.put(headerKeyValueArray[0], headerKeyValueArray[1]);
            }
            if (this.serviceConfigs.getSequenceName() != null) {
                this.headersMap.put("sequence", this.serviceConfigs.getSequenceName());
            }
        }
        return null;
    }

    private TrustManagerFactory getTrustManagerFactory(String filePath, String password, String algorithm, String storeType) {
        char[] passphrase = password.toCharArray();
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType);
            try (FileInputStream fis = new FileInputStream(filePath);){
                keyStore.load(fis, passphrase);
            }
            catch (IOException e) {
                throw new SiddhiAppCreationException(this.siddhiAppName + ": " + this.streamID + ": " + e.getMessage(), (Throwable)e);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(keyStore);
            return tmf;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SiddhiAppCreationException(this.siddhiAppName + ": " + this.streamID + ": Error while reading truststore " + e.getMessage(), (Throwable)e);
        }
    }

    private KeyManagerFactory getKeyManagerFactory(String filePath, String password, String algorithm, String storeType) {
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType);
            char[] passphrase = password.toCharArray();
            try (FileInputStream fis = new FileInputStream(filePath);){
                keyStore.load(fis, passphrase);
            }
            catch (IOException e) {
                throw new SiddhiAppCreationException(this.siddhiAppName + ": " + this.streamID + ": " + e.getMessage(), (Throwable)e);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(keyStore, passphrase);
            return kmf;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new SiddhiAppCreationException(this.siddhiAppName + ": " + this.streamID + ": Error while reading keystore " + e.getMessage(), (Throwable)e);
        }
    }

    public abstract void initSink(OptionHolder var1);

    public void destroy() {
        this.channel = null;
    }

    public Event.Builder addHeadersToEventBuilder(DynamicOptions dynamicOptions, Event.Builder eventBuilder) {
        if (this.headersOption != null) {
            String[] headersArray;
            String headers = this.headersOption.getValue(dynamicOptions);
            headers = headers.replaceAll("'", "");
            for (String headerKeyValue : headersArray = headers.split(",")) {
                String[] headerKeyValueArray = headerKeyValue.split(":");
                eventBuilder.putHeaders(headerKeyValueArray[0], headerKeyValueArray[1]);
            }
        }
        if (this.serviceConfigs.getSequenceName() != null) {
            eventBuilder.putHeaders("sequence", this.serviceConfigs.getSequenceName());
        }
        return eventBuilder;
    }

    public AbstractStub attachMetaDataToStub(DynamicOptions dynamicOptions, AbstractStub stub) {
        String[] metadataArray;
        Metadata metadata = new Metadata();
        String metadataString = this.metadataOption.isStatic() ? this.metadataOption.getValue() : this.metadataOption.getValue(dynamicOptions);
        metadataString = metadataString.replaceAll("'", "");
        for (String metadataKeyValue : metadataArray = metadataString.split(",")) {
            String[] headerKeyValueArray = metadataKeyValue.split(":");
            metadata.put(Metadata.Key.of((String)headerKeyValueArray[0], (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)headerKeyValueArray[1]);
        }
        return MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata)metadata);
    }
}

