/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.source;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.stub.StreamObserver;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.extension.io.grpc.source.AbstractGrpcSource;
import io.siddhi.extension.io.grpc.source.GrpcServiceSource;
import io.siddhi.extension.io.grpc.source.GrpcWorkerThread;
import io.siddhi.extension.io.grpc.source.ServiceServer;
import io.siddhi.extension.io.grpc.util.GenericService;
import io.siddhi.extension.io.grpc.util.GrpcServerConfigs;
import io.siddhi.extension.io.grpc.util.GrpcUtils;
import io.siddhi.extension.io.grpc.util.SourceServerInterceptor;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenericServiceServer
extends ServiceServer {
    private static final Logger logger = LogManager.getLogger(GenericServiceServer.class);
    public static ThreadLocal<Map<String, String>> metaDataMap = new ThreadLocal();
    private Server server;
    private NettyServerBuilder serverBuilder;
    private GrpcServerConfigs grpcServerConfigs;
    private SourceServerInterceptor serverInterceptor;
    private ExecutorService executorService;
    private AbstractGrpcSource relevantSource;
    private Class requestClass;

    public GenericServiceServer(GrpcServerConfigs grpcServerConfigs, AbstractGrpcSource relevantSource, Class requestClass, String siddhiAppName, String streamID) {
        this.serverInterceptor = new SourceServerInterceptor(grpcServerConfigs.getServiceConfigs().isDefaultService());
        this.grpcServerConfigs = grpcServerConfigs;
        this.relevantSource = relevantSource;
        this.requestClass = requestClass;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.executorService = new ThreadPoolExecutor(grpcServerConfigs.getThreadPoolSize(), grpcServerConfigs.getThreadPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(grpcServerConfigs.getThreadPoolBufferSize()));
        this.setServerPropertiesToBuilder(siddhiAppName, streamID);
        this.addServicesAndBuildServer(siddhiAppName, streamID);
    }

    @Override
    protected void setServerPropertiesToBuilder(String siddhiAppName, String streamID) {
        this.serverBuilder = NettyServerBuilder.forPort((int)this.grpcServerConfigs.getServiceConfigs().getPort());
        if (this.grpcServerConfigs.getServiceConfigs().getKeystoreFilePath() != null) {
            try {
                SslContextBuilder sslContextBuilder = this.getSslContextBuilder(this.grpcServerConfigs.getServiceConfigs().getKeystoreFilePath(), this.grpcServerConfigs.getServiceConfigs().getKeystorePassword(), this.grpcServerConfigs.getServiceConfigs().getKeystoreAlgorithm(), this.grpcServerConfigs.getServiceConfigs().getTlsStoreType(), siddhiAppName, streamID);
                if (this.grpcServerConfigs.getServiceConfigs().getTruststoreFilePath() != null) {
                    sslContextBuilder = this.addTrustStore(this.grpcServerConfigs.getServiceConfigs().getTruststoreFilePath(), this.grpcServerConfigs.getServiceConfigs().getTruststorePassword(), this.grpcServerConfigs.getServiceConfigs().getTruststoreAlgorithm(), sslContextBuilder, this.grpcServerConfigs.getServiceConfigs().getTlsStoreType(), siddhiAppName, streamID).clientAuth(ClientAuth.REQUIRE);
                }
                this.serverBuilder.sslContext(sslContextBuilder.build());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw new SiddhiAppCreationException(siddhiAppName + ": " + streamID + ": Error while creating SslContext. " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.grpcServerConfigs.getMaxInboundMessageSize() != -1) {
            this.serverBuilder.maxInboundMessageSize(this.grpcServerConfigs.getMaxInboundMessageSize());
        }
        if (this.grpcServerConfigs.getMaxInboundMetadataSize() != -1) {
            this.serverBuilder.maxInboundMetadataSize(this.grpcServerConfigs.getMaxInboundMetadataSize());
        }
    }

    @Override
    protected void addServicesAndBuildServer(final String siddhiAppName, final String streamID) {
        this.server = ((NettyServerBuilder)this.serverBuilder.addService(ServerInterceptors.intercept((BindableService)new GenericService.AnyServiceImplBase(){

            @Override
            public void handleEmptyResponse(Any request, StreamObserver<Empty> responseObserver) {
                GenericServiceServer.this.handlePause(logger);
                try {
                    Object requestMessageObject = GenericServiceServer.this.requestClass.getDeclaredMethod("parseFrom", ByteString.class).invoke((Object)GenericServiceServer.this.requestClass, request.toByteString());
                    GenericServiceServer.this.executorService.execute(new GrpcWorkerThread(GenericServiceServer.this.relevantSource, requestMessageObject, null, metaDataMap.get()));
                    responseObserver.onNext((Object)Empty.getDefaultInstance());
                    responseObserver.onCompleted();
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new SiddhiAppValidationException(siddhiAppName + ": " + streamID + ": Invalid method name provided in the url, provided method name: " + GenericServiceServer.this.grpcServerConfigs.getServiceConfigs().getMethodName() + ", Expected one of these these methods: " + GrpcUtils.getRpcMethodList(GenericServiceServer.this.grpcServerConfigs.getServiceConfigs(), siddhiAppName, streamID), (Throwable)e);
                }
                catch (SiddhiAppRuntimeException e) {
                    logger.error(siddhiAppName + ": " + streamID + ": Dropping request. " + e.getMessage());
                    responseObserver.onError((Throwable)new StatusRuntimeException(Status.DATA_LOSS));
                }
            }

            @Override
            public StreamObserver<Any> clientStream(final StreamObserver<Empty> responseObserver) {
                GenericServiceServer.this.handlePause(logger);
                return new StreamObserver<Any>(){

                    public void onNext(Any value) {
                        try {
                            Object requestMessageObject = GenericServiceServer.this.requestClass.getDeclaredMethod("parseFrom", ByteString.class).invoke((Object)GenericServiceServer.this.requestClass, value.toByteString());
                            GenericServiceServer.this.executorService.execute(new GrpcWorkerThread(GenericServiceServer.this.relevantSource, requestMessageObject, null, metaDataMap.get()));
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            throw new SiddhiAppValidationException(siddhiAppName + " :" + streamID + ": Invalid method name provided in the url, provided method name: " + GenericServiceServer.this.grpcServerConfigs.getServiceConfigs().getMethodName() + ", Expected one of these these methods: " + GrpcUtils.getRpcMethodList(GenericServiceServer.this.grpcServerConfigs.getServiceConfigs(), siddhiAppName, streamID), (Throwable)e);
                        }
                        catch (SiddhiAppRuntimeException e) {
                            logger.error(siddhiAppName + ": " + streamID + ": Dropping request. " + e.getMessage());
                            responseObserver.onError((Throwable)new StatusRuntimeException(Status.DATA_LOSS));
                        }
                    }

                    public void onError(Throwable t) {
                    }

                    public void onCompleted() {
                        responseObserver.onNext((Object)Empty.getDefaultInstance());
                        responseObserver.onCompleted();
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNonEmptyResponse(Any request, StreamObserver<Any> responseObserver) {
                Object requestObject;
                GenericServiceServer.this.handlePause(logger);
                try {
                    Method parseFrom = GenericServiceServer.this.requestClass.getDeclaredMethod("parseFrom", ByteString.class);
                    requestObject = parseFrom.invoke((Object)GenericServiceServer.this.requestClass, request.toByteString());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new SiddhiAppValidationException(siddhiAppName + ": " + streamID + ": Invalid method name provided in the url, provided method name: " + GenericServiceServer.this.grpcServerConfigs.getServiceConfigs().getMethodName() + ", Expected one of these these methods: " + GrpcUtils.getRpcMethodList(GenericServiceServer.this.grpcServerConfigs.getServiceConfigs(), siddhiAppName, streamID), (Throwable)e);
                }
                String messageId = UUID.randomUUID().toString();
                HashMap<String, String> transportPropertyMap = new HashMap<String, String>();
                transportPropertyMap.put("message.id", messageId);
                try {
                    GenericServiceServer.this.executorService.execute(new GrpcWorkerThread(GenericServiceServer.this.relevantSource, requestObject, transportPropertyMap, metaDataMap.get()));
                    ((GrpcServiceSource)GenericServiceServer.this.relevantSource).putStreamObserver(messageId, responseObserver);
                    ((GrpcServiceSource)GenericServiceServer.this.relevantSource).scheduleServiceTimeout(messageId);
                }
                catch (SiddhiAppRuntimeException e) {
                    logger.error(siddhiAppName + ": " + streamID + ": Dropping request. " + e.getMessage());
                    responseObserver.onError((Throwable)new StatusRuntimeException(Status.DATA_LOSS));
                }
                finally {
                    metaDataMap.remove();
                }
            }
        }, (ServerInterceptor[])new ServerInterceptor[]{this.serverInterceptor}))).build();
    }

    @Override
    public void connectServer(Logger logger, Source.ConnectionCallback connectionCallback, String siddhiAppName, String streamID) {
        try {
            this.server.start();
            if (logger.isDebugEnabled()) {
                logger.debug(siddhiAppName + ": " + streamID + ": gRPC Server started");
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof BindException) {
                throw new SiddhiAppRuntimeException(siddhiAppName + ": " + streamID + ": Another server is already running on the port " + this.grpcServerConfigs.getServiceConfigs().getPort() + ". Please provide a different port");
            }
            connectionCallback.onError(new ConnectionUnavailableException(siddhiAppName + ": " + streamID + ": Error when starting the server. " + e.getMessage(), (Throwable)e));
            throw new SiddhiAppRuntimeException(siddhiAppName + ": " + streamID + ": ", (Throwable)e);
        }
    }

    @Override
    public void disconnectServer(Logger logger, String siddhiAppName, String streamID) {
        try {
            if (this.server == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(siddhiAppName + ": " + streamID + ": Illegal state. Server already stopped.");
                }
                return;
            }
            this.server.shutdown();
            if (this.grpcServerConfigs.getServerShutdownWaitingTimeInMillis() > 0L) {
                if (this.server.awaitTermination(this.grpcServerConfigs.getServerShutdownWaitingTimeInMillis(), TimeUnit.MILLISECONDS)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(siddhiAppName + ": " + streamID + ": Server stopped");
                    }
                    return;
                }
                this.server.shutdownNow();
                if (this.server.awaitTermination(this.grpcServerConfigs.getServerShutdownWaitingTimeInMillis(), TimeUnit.MILLISECONDS)) {
                    return;
                }
                throw new SiddhiAppRuntimeException(siddhiAppName + ": " + streamID + ": Unable to shutdown server");
            }
        }
        catch (InterruptedException e) {
            throw new SiddhiAppRuntimeException(siddhiAppName + ": " + streamID + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public SslContextBuilder getSslContextBuilder(String filePath, String password, String algorithm, String storeType, String siddhiAppName, String streamID) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        char[] passphrase = password.toCharArray();
        KeyStore keyStore = KeyStore.getInstance(storeType);
        try (FileInputStream fis = new FileInputStream(filePath);){
            keyStore.load(fis, passphrase);
        }
        catch (IOException e) {
            throw new SiddhiAppCreationException(siddhiAppName + ": " + streamID + ": " + e.getMessage(), (Throwable)e);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(keyStore, passphrase);
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)kmf);
        sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
        return sslContextBuilder;
    }

    @Override
    protected SslContextBuilder addTrustStore(String filePath, String password, String algorithm, SslContextBuilder sslContextBuilder, String storeType, String siddhiAppName, String streamID) throws NoSuchAlgorithmException, KeyStoreException, CertificateException {
        char[] passphrase = password.toCharArray();
        KeyStore keyStore = KeyStore.getInstance(storeType);
        try (FileInputStream fis = new FileInputStream(filePath);){
            keyStore.load(fis, passphrase);
        }
        catch (IOException e) {
            throw new SiddhiAppCreationException(siddhiAppName + ": " + streamID + ": " + e.getMessage(), (Throwable)e);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        tmf.init(keyStore);
        return sslContextBuilder.trustManager(tmf).clientAuth(ClientAuth.REQUIRE);
    }
}

