/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.source;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.extension.io.grpc.source.AbstractGrpcSource;
import io.siddhi.extension.io.grpc.source.GrpcEventServiceServer;
import io.siddhi.extension.io.grpc.util.GrpcServerConfigs;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class GrpcServerManager {
    private static GrpcServerManager instance = new GrpcServerManager();
    private Map<Integer, GrpcEventServiceServer> grpcPortServerMap = Collections.synchronizedMap(new HashMap());

    public static GrpcServerManager getInstance() {
        return instance;
    }

    public void registerSource(GrpcServerConfigs serverConfigs, AbstractGrpcSource source, String methodName, SiddhiAppContext siddhiAppContext, String streamID) {
        if (this.grpcPortServerMap.containsKey(serverConfigs.getServiceConfigs().getPort())) {
            if (!this.grpcPortServerMap.get(serverConfigs.getServiceConfigs().getPort()).getGrpcServerConfigs().equals(serverConfigs)) {
                throw new SiddhiAppValidationException(siddhiAppContext.getName() + ": " + streamID + ": A server with different configuration is already running on port " + serverConfigs.getServiceConfigs().getPort() + ". Please provide a different port or provide same configurations as server running on the given port.");
            }
            this.grpcPortServerMap.get(serverConfigs.getServiceConfigs().getPort()).subscribe(source.getStreamID(), source, methodName, siddhiAppContext);
        } else {
            GrpcEventServiceServer server = new GrpcEventServiceServer(serverConfigs, siddhiAppContext, streamID);
            server.subscribe(source.getStreamID(), source, serverConfigs.getServiceConfigs().getMethodName(), siddhiAppContext);
            this.grpcPortServerMap.put(serverConfigs.getServiceConfigs().getPort(), server);
        }
    }

    public void unregisterSource(int port, String streamID, String methodName, Logger logger, SiddhiAppContext siddhiAppContext) {
        this.grpcPortServerMap.get(port).unsubscribe(streamID, methodName, siddhiAppContext);
        if (this.grpcPortServerMap.get(port).getNumSubscribers() == 0) {
            this.grpcPortServerMap.get(port).disconnectServer(logger, siddhiAppContext.getName(), streamID);
            this.grpcPortServerMap.remove(port);
        }
    }

    public GrpcEventServiceServer getServer(int port) {
        return this.grpcPortServerMap.get(port);
    }
}

