/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.util;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.protobuf.ProtoMethodDescriptorSupplier;
import io.grpc.protobuf.ProtoServiceDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

public class GenericService {
    private static volatile String serviceName = "";
    private static volatile String nonEmptyResponseMethodName = "nonEmptyResponse";
    private static volatile String emptyResponseMethodName = "emptyResponse";
    private static volatile String clientStreamMethodName = "clientStreaming";
    private static volatile MethodDescriptor<Any, Empty> emptyResponseHandle;
    private static volatile MethodDescriptor<Any, Any> nonEmptyResponseHandle;
    private static volatile MethodDescriptor<Any, Empty> getClientStreamMethod;

    public static void setServiceName(String serviceName) {
        GenericService.serviceName = serviceName;
    }

    public static void setNonEmptyResponseMethodName(String nonEmptyResponseMethodName) {
        GenericService.nonEmptyResponseMethodName = nonEmptyResponseMethodName;
    }

    public static void setEmptyResponseMethodName(String emptyResponseMethodName) {
        GenericService.emptyResponseMethodName = emptyResponseMethodName;
    }

    public static void setClientStreamMethodName(String clientStreamMethodName) {
        GenericService.clientStreamMethodName = clientStreamMethodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceDescriptor getServiceDescriptor() {
        Class<GenericService> clazz = GenericService.class;
        synchronized (GenericService.class) {
            ServiceDescriptor result = ServiceDescriptor.newBuilder((String)serviceName).setSchemaDescriptor((Object)new AnyServiceFileDescriptorSupplier()).addMethod(GenericService.getEmptyResponseHandle()).addMethod(GenericService.getHandleNonEmptyResponse()).addMethod(GenericService.getClientStreamMethod()).build();
            // ** MonitorExit[var1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<Any, Empty> getEmptyResponseHandle() {
        MethodDescriptor nonResponseMethod = null;
        nonResponseMethod = emptyResponseHandle;
        if (nonResponseMethod != null && nonResponseMethod.getFullMethodName().equals(serviceName + "/" + emptyResponseMethodName)) return nonResponseMethod;
        Class<GenericService> clazz = GenericService.class;
        synchronized (GenericService.class) {
            emptyResponseHandle = null;
            nonResponseMethod = emptyResponseHandle;
            if (nonResponseMethod != null && nonResponseMethod.getFullMethodName().equals(serviceName + "/" + emptyResponseMethodName)) return nonResponseMethod;
            emptyResponseHandle = nonResponseMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceName, (String)emptyResponseMethodName)).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)Any.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSchemaDescriptor((Object)new AnyServiceMethodDescriptorSupplier(emptyResponseMethodName)).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return nonResponseMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<Any, Any> getHandleNonEmptyResponse() {
        MethodDescriptor responseMethod = nonEmptyResponseHandle;
        if (responseMethod != null && responseMethod.getFullMethodName().equals(serviceName + "/" + nonEmptyResponseMethodName)) return responseMethod;
        Class<GenericService> clazz = GenericService.class;
        synchronized (GenericService.class) {
            nonEmptyResponseHandle = null;
            responseMethod = nonEmptyResponseHandle;
            if (responseMethod != null && responseMethod.getFullMethodName().equals(serviceName + "/" + nonEmptyResponseMethodName)) return responseMethod;
            nonEmptyResponseHandle = responseMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceName, (String)nonEmptyResponseMethodName)).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)Any.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Any.getDefaultInstance())).setSchemaDescriptor((Object)new AnyServiceMethodDescriptorSupplier(nonEmptyResponseMethodName)).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return responseMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<Any, Empty> getClientStreamMethod() {
        MethodDescriptor getClientStreamMethod = GenericService.getClientStreamMethod;
        if (getClientStreamMethod != null && getClientStreamMethod.getFullMethodName().equals(serviceName + "/" + clientStreamMethodName)) return getClientStreamMethod;
        Class<GenericService> clazz = GenericService.class;
        synchronized (GenericService.class) {
            GenericService.getClientStreamMethod = null;
            getClientStreamMethod = GenericService.getClientStreamMethod;
            if (getClientStreamMethod != null) return getClientStreamMethod;
            GenericService.getClientStreamMethod = getClientStreamMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.CLIENT_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceName, (String)clientStreamMethodName)).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller((Message)Any.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSchemaDescriptor((Object)new AnyServiceMethodDescriptorSupplier(clientStreamMethodName)).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getClientStreamMethod;
        }
    }

    public static abstract class AnyServiceImplBase
    implements BindableService {
        public void handleEmptyResponse(Any request, StreamObserver<Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(GenericService.getEmptyResponseHandle(), responseObserver);
        }

        public void handleNonEmptyResponse(Any request, StreamObserver<Any> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(GenericService.getHandleNonEmptyResponse(), responseObserver);
        }

        public StreamObserver<Any> clientStream(StreamObserver<Empty> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(GenericService.getClientStreamMethod(), responseObserver);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)GenericService.getServiceDescriptor()).addMethod(GenericService.getEmptyResponseHandle(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(GenericService.getHandleNonEmptyResponse(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(GenericService.getClientStreamMethod(), ServerCalls.asyncClientStreamingCall(new MethodHandlers(this, 3))).build();
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final AnyServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(AnyServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    this.serviceImpl.handleEmptyResponse((Any)request, responseObserver);
                    break;
                }
                case 2: {
                    this.serviceImpl.handleNonEmptyResponse((Any)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 3: {
                    return this.serviceImpl.clientStream(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    private static final class AnyServiceMethodDescriptorSupplier
    extends AnyServiceBaseDescriptorSupplier
    implements ProtoMethodDescriptorSupplier {
        private final String methodName;

        AnyServiceMethodDescriptorSupplier(String methodName) {
            this.methodName = methodName;
        }

        public Descriptors.MethodDescriptor getMethodDescriptor() {
            return this.getServiceDescriptor().findMethodByName(this.methodName);
        }
    }

    private static final class AnyServiceFileDescriptorSupplier
    extends AnyServiceBaseDescriptorSupplier {
        AnyServiceFileDescriptorSupplier() {
        }
    }

    private static abstract class AnyServiceBaseDescriptorSupplier
    implements ProtoFileDescriptorSupplier,
    ProtoServiceDescriptorSupplier {
        AnyServiceBaseDescriptorSupplier() {
        }

        public Descriptors.FileDescriptor getFileDescriptor() {
            return null;
        }

        public Descriptors.ServiceDescriptor getServiceDescriptor() {
            return this.getFileDescriptor().findServiceByName(serviceName);
        }
    }
}

