/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.util;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.grpc.util.GrpcUtils;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceConfigs {
    private static final Logger log = LoggerFactory.getLogger((String)ServiceConfigs.class.getName());
    private String url;
    private String serviceName;
    private int port;
    private String methodName;
    private String hostPort;
    private String sequenceName;
    private boolean isDefaultService = false;
    private String fullyQualifiedServiceName;
    private String truststoreFilePath;
    private String truststorePassword;
    private String keystoreFilePath;
    private String keystorePassword;
    private String truststoreAlgorithm;
    private String keystoreAlgorithm;
    private String tlsStoreType;
    private boolean isSslEnabled;
    private boolean isMutualAuthEnabled;

    public ServiceConfigs(OptionHolder optionHolder, SiddhiAppContext siddhiAppContext, String streamID, ConfigReader configReader, boolean isSource) {
        URL aURL;
        if (optionHolder.isOptionExists("receiver.url")) {
            this.url = optionHolder.validateAndGetOption("receiver.url").getValue();
            log.debug("GRPC Service for : " + streamID + " started" + this.url);
        } else if (optionHolder.isOptionExists("publisher.url")) {
            this.url = optionHolder.validateAndGetOption("publisher.url").getValue();
        } else {
            throw new SiddhiAppValidationException(siddhiAppContext.getName() + ": " + streamID + ": either receiver.url or publisher.url should be given. But found neither");
        }
        if (!this.url.startsWith("grpc")) {
            throw new SiddhiAppValidationException(siddhiAppContext.getName() + ": " + streamID + ": The url must begin with \"" + "grpc" + "\" for all grpc sinks");
        }
        try {
            aURL = new URL("http" + this.url.substring(4));
        }
        catch (MalformedURLException e) {
            throw new SiddhiAppValidationException(siddhiAppContext.getName() + ": " + streamID + ": Error in URL format. Expected format is `grpc://0.0.0.0:9763/<serviceName>/<methodName>` but the provided url is " + this.url + ". ", (Throwable)e);
        }
        this.port = aURL.getPort();
        this.hostPort = aURL.getAuthority();
        if (this.port == -1 || this.hostPort == null || aURL.getPath().equals("")) {
            throw new SiddhiAppValidationException(siddhiAppContext.getName() + ": " + streamID + ": URL not properly given. Expected format is `grpc://0.0.0.0:9763/<serviceName>/<methodName>` or `grpc://0.0.0.0:9763/<sequenceName>` but the provided url is " + this.url + ". ");
        }
        ArrayList<String> urlPathParts = new ArrayList<String>(Arrays.asList(aURL.getPath().substring(1).split("/")));
        if (urlPathParts.contains("")) {
            throw new SiddhiAppValidationException(siddhiAppContext.getName() + ":" + streamID + "Malformed URL. There should not be any empty parts in the URL between two '/'");
        }
        if (urlPathParts.size() < 2) {
            this.fullyQualifiedServiceName = "org.wso2.grpc.EventService";
            this.serviceName = "EventService";
            this.sequenceName = (String)urlPathParts.get(0);
        } else {
            this.methodName = (String)urlPathParts.get(1);
            this.fullyQualifiedServiceName = (String)urlPathParts.get(0);
            String[] fullyQualifiedServiceNameParts = this.fullyQualifiedServiceName.split("\\.");
            this.serviceName = fullyQualifiedServiceNameParts[fullyQualifiedServiceNameParts.length - 1];
        }
        if (this.fullyQualifiedServiceName.equalsIgnoreCase("org.wso2.grpc.EventService")) {
            this.isDefaultService = true;
            if (urlPathParts.size() == 3) {
                this.sequenceName = (String)urlPathParts.get(2);
            }
        }
        if (optionHolder.isOptionExists("enable.ssl")) {
            this.isSslEnabled = Boolean.parseBoolean(optionHolder.validateAndGetOption("enable.ssl").getValue());
        }
        if (optionHolder.isOptionExists("mutual.auth.enabled")) {
            this.isMutualAuthEnabled = Boolean.parseBoolean(optionHolder.validateAndGetOption("mutual.auth.enabled").getValue());
        }
        if (this.isSslEnabled) {
            if (isSource) {
                this.getKeystore(optionHolder, configReader);
                if (this.isMutualAuthEnabled) {
                    this.getTruststore(optionHolder, configReader);
                }
            } else {
                this.getTruststore(optionHolder, configReader);
                if (this.isMutualAuthEnabled) {
                    this.getKeystore(optionHolder, configReader);
                }
            }
        }
    }

    private void getKeystore(OptionHolder optionHolder, ConfigReader configReader) {
        if (optionHolder.isOptionExists("keystore.file")) {
            this.keystoreFilePath = optionHolder.validateAndGetOption("keystore.file").getValue();
            this.keystorePassword = optionHolder.validateAndGetOption("keystore.password").getValue();
            this.keystoreAlgorithm = optionHolder.validateAndGetOption("keystore.algorithm").getValue();
            this.tlsStoreType = optionHolder.getOrCreateOption("tls.store.type", "JKS").getValue();
        } else if (configReader.readConfig("keyStoreFile", null) != null) {
            this.keystoreFilePath = configReader.readConfig("keyStoreFile", "${carbon.home}/resources/security/wso2carbon.jks");
            this.keystorePassword = configReader.readConfig("keyStorePassword", "wso2carbon");
            this.keystoreAlgorithm = configReader.readConfig("keyStoreAlgorithm", "SunX509");
            this.tlsStoreType = optionHolder.getOrCreateOption("tls.store.type", "JKS").getValue();
        } else {
            this.keystoreFilePath = "${carbon.home}/resources/security/wso2carbon.jks";
            this.keystorePassword = "wso2carbon";
            this.keystoreAlgorithm = "SunX509";
            this.tlsStoreType = optionHolder.getOrCreateOption("tls.store.type", "JKS").getValue();
        }
    }

    private void getTruststore(OptionHolder optionHolder, ConfigReader configReader) {
        if (optionHolder.isOptionExists("truststore.file")) {
            this.truststoreFilePath = optionHolder.validateAndGetOption("truststore.file").getValue();
            if (optionHolder.isOptionExists("truststore.password")) {
                this.truststorePassword = optionHolder.validateAndGetOption("truststore.password").getValue();
            }
            this.truststoreAlgorithm = optionHolder.validateAndGetOption("truststore.algorithm").getValue();
            this.tlsStoreType = optionHolder.getOrCreateOption("tls.store.type", "JKS").getValue();
        } else if (configReader.readConfig("trustStoreFile", null) != null) {
            this.truststoreFilePath = configReader.readConfig("trustStoreFile", "${carbon.home}/resources/security/client-truststore.jks");
            this.truststorePassword = configReader.readConfig("trustStorePassword", "wso2carbon");
            this.truststoreAlgorithm = configReader.readConfig("trustStoreAlgorithm", "SunX509");
            this.tlsStoreType = optionHolder.getOrCreateOption("tls.store.type", "JKS").getValue();
        } else {
            this.truststoreFilePath = "${carbon.home}/resources/security/client-truststore.jks";
            this.truststorePassword = "wso2carbon";
            this.truststoreAlgorithm = "SunX509";
            this.tlsStoreType = optionHolder.getOrCreateOption("tls.store.type", "JKS").getValue();
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFullyQualifiedServiceName() {
        return this.fullyQualifiedServiceName;
    }

    public int getPort() {
        return this.port;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public boolean isDefaultService() {
        return this.isDefaultService;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTruststoreFilePath() {
        if (this.truststoreFilePath != null) {
            return GrpcUtils.substituteVariables(this.truststoreFilePath);
        }
        return null;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getKeystoreFilePath() {
        if (this.keystoreFilePath != null) {
            return GrpcUtils.substituteVariables(this.keystoreFilePath);
        }
        return null;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getTruststoreAlgorithm() {
        return this.truststoreAlgorithm;
    }

    public String getKeystoreAlgorithm() {
        return this.keystoreAlgorithm;
    }

    public String getTlsStoreType() {
        return this.tlsStoreType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!ServiceConfigs.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ServiceConfigs other = (ServiceConfigs)obj;
        if (!Objects.equals(this.url, other.url)) {
            return false;
        }
        if (!Objects.equals(this.serviceName, other.serviceName)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (!Objects.equals(this.methodName, other.methodName)) {
            return false;
        }
        if (!Objects.equals(this.hostPort, other.hostPort)) {
            return false;
        }
        if (!Objects.equals(this.sequenceName, other.sequenceName)) {
            return false;
        }
        if (this.isDefaultService != other.isDefaultService) {
            return false;
        }
        if (!Objects.equals(this.fullyQualifiedServiceName, other.fullyQualifiedServiceName)) {
            return false;
        }
        if (!Objects.equals(this.truststoreFilePath, other.truststoreFilePath)) {
            return false;
        }
        if (!Objects.equals(this.truststorePassword, other.truststorePassword)) {
            return false;
        }
        if (!Objects.equals(this.keystoreFilePath, other.keystoreFilePath)) {
            return false;
        }
        if (!Objects.equals(this.keystorePassword, other.keystorePassword)) {
            return false;
        }
        if (!Objects.equals(this.truststoreAlgorithm, other.truststoreAlgorithm)) {
            return false;
        }
        if (!Objects.equals(this.keystoreAlgorithm, other.keystoreAlgorithm)) {
            return false;
        }
        if (!Objects.equals(this.tlsStoreType, other.tlsStoreType)) {
            return false;
        }
        return this.isSslEnabled == other.isSslEnabled;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.url).append((Object)this.serviceName).append(this.port).append((Object)this.methodName).append((Object)this.hostPort).append((Object)this.sequenceName).append(this.isDefaultService).append((Object)this.fullyQualifiedServiceName).append((Object)this.truststoreFilePath).append((Object)this.truststorePassword).append((Object)this.keystoreFilePath).append((Object)this.keystorePassword).append((Object)this.truststoreAlgorithm).append((Object)this.keystoreAlgorithm).append((Object)this.tlsStoreType).append(this.isSslEnabled).toHashCode();
    }
}

