/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.source;

import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.siddhi.core.stream.input.source.Source;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;

public abstract class ServiceServer {
    protected boolean paused;
    protected ReentrantLock lock;
    protected Condition condition;

    protected abstract void setServerPropertiesToBuilder(String var1, String var2);

    protected abstract void addServicesAndBuildServer(String var1, String var2);

    protected abstract void connectServer(Logger var1, Source.ConnectionCallback var2, String var3, String var4);

    protected abstract void disconnectServer(Logger var1, String var2, String var3);

    protected abstract SslContextBuilder getSslContextBuilder(String var1, String var2, String var3, String var4, String var5, String var6) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException;

    protected abstract SslContextBuilder addTrustStore(String var1, String var2, String var3, SslContextBuilder var4, String var5, String var6, String var7) throws NoSuchAlgorithmException, KeyStoreException, CertificateException;

    public void pause(Logger logger, String url) {
        this.lock.lock();
        try {
            this.paused = true;
            logger.info("Event input has paused for " + url);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void resume(Logger logger, String url) {
        this.lock.lock();
        try {
            this.paused = false;
            logger.info("Event input has resume for " + url);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void handlePause(Logger logger) {
        if (this.paused) {
            this.lock.lock();
            try {
                while (this.paused) {
                    this.condition.await();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Thread interrupted while pausing ", (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

