/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.util;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.siddhi.extension.io.grpc.source.GenericServiceServer;
import io.siddhi.extension.io.grpc.source.GrpcEventServiceServer;
import java.util.HashMap;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SourceServerInterceptor
implements ServerInterceptor {
    private static final Logger logger = LogManager.getLogger(SourceServerInterceptor.class);
    private boolean isDefaultService;

    public SourceServerInterceptor(boolean isDefaultService) {
        this.isDefaultService = isDefaultService;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        logger.debug("Interceptor thread is: " + Thread.currentThread().getId());
        Set<String> metadataKeys = metadata.keys();
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        for (String key : metadataKeys) {
            metaDataMap.put(key, metadata.get(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER)));
        }
        if (this.isDefaultService) {
            GrpcEventServiceServer.metaDataMap.set(metaDataMap);
        } else {
            GenericServiceServer.metaDataMap.set(metaDataMap);
        }
        return Contexts.interceptCall(Context.ROOT, serverCall, metadata, serverCallHandler);
    }
}

