/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.util;

import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.extension.io.grpc.util.ServiceConfigs;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GrpcUtils {
    public static String[] extractHeaders(Map<String, String> headersMap, Map<String, String> metaDataMap, String[] requestedTransportPropertyNames) {
        if (requestedTransportPropertyNames == null) {
            return new String[0];
        }
        String[] headersArray = new String[requestedTransportPropertyNames.length];
        for (int i = 0; i < requestedTransportPropertyNames.length; ++i) {
            if (headersMap != null && headersMap.containsKey(requestedTransportPropertyNames[i])) {
                headersArray[i] = headersMap.get(requestedTransportPropertyNames[i]);
            }
            if (!metaDataMap.containsKey(requestedTransportPropertyNames[i])) continue;
            headersArray[i] = metaDataMap.get(requestedTransportPropertyNames[i]);
        }
        List<String> headersArrayList = Arrays.asList(headersArray);
        if (headersArrayList.contains(null)) {
            throw new SiddhiAppRuntimeException("Requested transport property '" + requestedTransportPropertyNames[headersArrayList.indexOf(null)] + "' not present in received event");
        }
        return headersArray;
    }

    public static List<String> getRpcMethodList(ServiceConfigs serviceConfigs, String siddhiAppName, String streamID) {
        Method[] methodsInStub;
        ArrayList<String> rpcMethodNameList = new ArrayList<String>();
        String stubReference = serviceConfigs.getFullyQualifiedServiceName() + "Grpc" + "$" + serviceConfigs.getServiceName() + "Stub";
        try {
            methodsInStub = Class.forName(stubReference).getMethods();
        }
        catch (ClassNotFoundException e) {
            throw new SiddhiAppValidationException(siddhiAppName + ":" + streamID + ": Invalid service name provided in the url, provided service name: '" + serviceConfigs.getFullyQualifiedServiceName() + "'", (Throwable)e);
        }
        for (Method method : methodsInStub) {
            if (!method.getDeclaringClass().getName().equals(stubReference)) continue;
            rpcMethodNameList.add(method.getName());
        }
        return rpcMethodNameList;
    }
}

