/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.util;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.grpc.util.ServiceConfigs;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class GrpcServerConfigs {
    private ServiceConfigs serviceConfigs;
    private int maxInboundMessageSize = -1;
    private int maxInboundMetadataSize = -1;
    private long serverShutdownWaitingTimeInMillis = -1L;
    private int threadPoolSize;
    private int threadPoolBufferSize;

    public GrpcServerConfigs(OptionHolder optionHolder, SiddhiAppContext siddhiAppContext, String streamID, ConfigReader configReader) {
        this.serviceConfigs = new ServiceConfigs(optionHolder, siddhiAppContext, streamID, configReader);
        if (optionHolder.isOptionExists("max.inbound.message.size")) {
            this.maxInboundMessageSize = Integer.parseInt(optionHolder.validateAndGetOption("max.inbound.message.size").getValue());
        }
        if (optionHolder.isOptionExists("max.inbound.metadata.size")) {
            this.maxInboundMetadataSize = Integer.parseInt(optionHolder.validateAndGetOption("max.inbound.metadata.size").getValue());
        }
        if (optionHolder.isOptionExists("server.shutdown.waiting.time")) {
            this.serverShutdownWaitingTimeInMillis = Long.parseLong(optionHolder.validateAndGetOption("server.shutdown.waiting.time").getValue());
        }
        this.threadPoolSize = Integer.parseInt(optionHolder.getOrCreateOption("threadpool.size", "100").getValue());
        this.threadPoolBufferSize = Integer.parseInt(optionHolder.getOrCreateOption("threadpool.buffer.size", "100").getValue());
    }

    public ServiceConfigs getServiceConfigs() {
        return this.serviceConfigs;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public int getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    public long getServerShutdownWaitingTimeInMillis() {
        return this.serverShutdownWaitingTimeInMillis;
    }

    public int getThreadPoolBufferSize() {
        return this.threadPoolBufferSize;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!GrpcServerConfigs.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        GrpcServerConfigs other = (GrpcServerConfigs)obj;
        return new EqualsBuilder().appendSuper(this.getServiceConfigs().equals(other.getServiceConfigs())).append(this.maxInboundMessageSize, other.maxInboundMessageSize).append(this.maxInboundMetadataSize, other.maxInboundMetadataSize).append(this.serverShutdownWaitingTimeInMillis, other.serverShutdownWaitingTimeInMillis).append(this.threadPoolSize, other.threadPoolSize).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 29).appendSuper(this.serviceConfigs.hashCode()).append(this.maxInboundMessageSize).append(this.maxInboundMetadataSize).append(this.serverShutdownWaitingTimeInMillis).append(this.threadPoolSize).toHashCode();
    }
}

