/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.source;

import com.google.protobuf.GeneratedMessageV3;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.grpc.source.ServiceServer;
import io.siddhi.extension.io.grpc.util.GrpcServerConfigs;
import io.siddhi.extension.io.grpc.util.GrpcUtils;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;

public abstract class AbstractGrpcSource
extends Source {
    protected SiddhiAppContext siddhiAppContext;
    protected SourceEventListener sourceEventListener;
    private String[] requestedTransportPropertyNames;
    protected String streamID;
    private ServiceDeploymentInfo serviceDeploymentInfo;
    protected GrpcServerConfigs grpcServerConfigs;
    protected String siddhiAppName;
    protected Class requestClass;
    protected ServiceServer serviceServer;

    protected ServiceDeploymentInfo exposeServiceDeploymentInfo() {
        return this.serviceDeploymentInfo;
    }

    public StateFactory init(SourceEventListener sourceEventListener, OptionHolder optionHolder, String[] requestedTransportPropertyNames, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.streamID = sourceEventListener.getStreamDefinition().getId();
        this.siddhiAppContext = siddhiAppContext;
        this.siddhiAppName = siddhiAppContext.getName();
        this.sourceEventListener = sourceEventListener;
        this.requestedTransportPropertyNames = (String[])requestedTransportPropertyNames.clone();
        this.grpcServerConfigs = new GrpcServerConfigs(optionHolder, siddhiAppContext, this.streamID, configReader);
        if (!this.grpcServerConfigs.getServiceConfigs().isDefaultService()) {
            this.requestClass = this.getRequestClass();
        }
        this.initSource(optionHolder, requestedTransportPropertyNames);
        this.serviceDeploymentInfo = new ServiceDeploymentInfo(this.grpcServerConfigs.getServiceConfigs().getPort(), this.grpcServerConfigs.getServiceConfigs().getTruststoreFilePath() != null || this.grpcServerConfigs.getServiceConfigs().getKeystoreFilePath() != null);
        return null;
    }

    public void handleInjection(Object payload, String[] headers) {
        this.sourceEventListener.onEvent(payload, headers);
    }

    private Class getRequestClass() {
        Field methodDescriptor;
        String camelCaseMethodName = this.grpcServerConfigs.getServiceConfigs().getMethodName().substring(0, 1).toUpperCase() + this.grpcServerConfigs.getServiceConfigs().getMethodName().substring(1);
        try {
            methodDescriptor = Class.forName(this.grpcServerConfigs.getServiceConfigs().getFullyQualifiedServiceName() + "Grpc").getDeclaredField("get" + camelCaseMethodName + "Method");
        }
        catch (ClassNotFoundException e) {
            throw new SiddhiAppValidationException(this.siddhiAppName + ":" + this.streamID + ": Invalid service name provided in the url, provided service name: " + this.grpcServerConfigs.getServiceConfigs().getFullyQualifiedServiceName(), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new SiddhiAppValidationException(this.siddhiAppName + ":" + this.streamID + ": Invalid method name provided in the url, provided method name: " + this.grpcServerConfigs.getServiceConfigs().getMethodName() + ", Expected one of these these methods: " + GrpcUtils.getRpcMethodList(this.grpcServerConfigs.getServiceConfigs(), this.siddhiAppName, this.streamID), (Throwable)e);
        }
        ParameterizedType parameterizedType = (ParameterizedType)methodDescriptor.getGenericType();
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    public abstract void initSource(OptionHolder var1, String[] var2);

    public Class[] getOutputEventClasses() {
        return new Class[]{String.class, GeneratedMessageV3.class};
    }

    public void destroy() {
    }

    public String[] getRequestedTransportPropertyNames() {
        return (String[])this.requestedTransportPropertyNames.clone();
    }

    public String getStreamID() {
        return this.streamID;
    }

    public abstract void logError(String var1);
}

