/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.util;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Empty;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.protobuf.ProtoMethodDescriptorSupplier;
import io.grpc.protobuf.ProtoServiceDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

public class GenericService {
    private static volatile String serviceName = "";
    private static volatile String nonEmptyResponseMethodName = "nonEmptyResponse";
    private static volatile String emptyResponseMethodName = "emptyResponse";
    private static volatile String clientStreamMethodName = "clientStreaming";
    private static volatile MethodDescriptor<Any, Empty> emptyResponseHandle;
    private static volatile MethodDescriptor<Any, Any> nonEmptyResponseHandle;
    private static volatile MethodDescriptor<Any, Empty> getClientStreamMethod;

    public static void setServiceName(String serviceName) {
        GenericService.serviceName = serviceName;
    }

    public static void setNonEmptyResponseMethodName(String nonEmptyResponseMethodName) {
        GenericService.nonEmptyResponseMethodName = nonEmptyResponseMethodName;
    }

    public static void setEmptyResponseMethodName(String emptyResponseMethodName) {
        GenericService.emptyResponseMethodName = emptyResponseMethodName;
    }

    public static void setClientStreamMethodName(String clientStreamMethodName) {
        GenericService.clientStreamMethodName = clientStreamMethodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceDescriptor getServiceDescriptor() {
        Class<GenericService> clazz = GenericService.class;
        synchronized (GenericService.class) {
            ServiceDescriptor result = ServiceDescriptor.newBuilder(serviceName).setSchemaDescriptor(new AnyServiceFileDescriptorSupplier()).addMethod(GenericService.getEmptyResponseHandle()).addMethod(GenericService.getHandleNonEmptyResponse()).addMethod(GenericService.getClientStreamMethod()).build();
            // ** MonitorExit[var1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<Any, Empty> getEmptyResponseHandle() {
        MethodDescriptor<Any, Empty> nonResponseMethod = null;
        nonResponseMethod = emptyResponseHandle;
        if (nonResponseMethod != null && nonResponseMethod.getFullMethodName().equals(serviceName + "/" + emptyResponseMethodName)) return nonResponseMethod;
        Class<GenericService> clazz = GenericService.class;
        synchronized (GenericService.class) {
            nonResponseMethod = emptyResponseHandle = null;
            if (nonResponseMethod != null && nonResponseMethod.getFullMethodName().equals(serviceName + "/" + emptyResponseMethodName)) return nonResponseMethod;
            emptyResponseHandle = nonResponseMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName(serviceName, emptyResponseMethodName)).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller(Any.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Empty.getDefaultInstance())).setSchemaDescriptor(new AnyServiceMethodDescriptorSupplier(emptyResponseMethodName)).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return nonResponseMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<Any, Any> getHandleNonEmptyResponse() {
        MethodDescriptor<Any, Any> responseMethod = nonEmptyResponseHandle;
        if (responseMethod != null && responseMethod.getFullMethodName().equals(serviceName + "/" + nonEmptyResponseMethodName)) return responseMethod;
        Class<GenericService> clazz = GenericService.class;
        synchronized (GenericService.class) {
            responseMethod = nonEmptyResponseHandle = null;
            if (responseMethod != null && responseMethod.getFullMethodName().equals(serviceName + "/" + nonEmptyResponseMethodName)) return responseMethod;
            nonEmptyResponseHandle = responseMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName(serviceName, nonEmptyResponseMethodName)).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller(Any.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Any.getDefaultInstance())).setSchemaDescriptor(new AnyServiceMethodDescriptorSupplier(nonEmptyResponseMethodName)).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return responseMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodDescriptor<Any, Empty> getClientStreamMethod() {
        MethodDescriptor<Any, Empty> getClientStreamMethod = GenericService.getClientStreamMethod;
        if (getClientStreamMethod != null && getClientStreamMethod.getFullMethodName().equals(serviceName + "/" + clientStreamMethodName)) return getClientStreamMethod;
        Class<GenericService> clazz = GenericService.class;
        synchronized (GenericService.class) {
            getClientStreamMethod = GenericService.getClientStreamMethod = null;
            if (getClientStreamMethod != null) return getClientStreamMethod;
            GenericService.getClientStreamMethod = getClientStreamMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.CLIENT_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName(serviceName, clientStreamMethodName)).setSampledToLocalTracing(true).setRequestMarshaller(ProtoUtils.marshaller(Any.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Empty.getDefaultInstance())).setSchemaDescriptor(new AnyServiceMethodDescriptorSupplier(clientStreamMethodName)).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return getClientStreamMethod;
        }
    }

    public static abstract class AnyServiceImplBase
    implements BindableService {
        public void handleEmptyResponse(Any request, StreamObserver<Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(GenericService.getEmptyResponseHandle(), responseObserver);
        }

        public void handleNonEmptyResponse(Any request, StreamObserver<Any> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(GenericService.getHandleNonEmptyResponse(), responseObserver);
        }

        public StreamObserver<Any> clientStream(StreamObserver<Empty> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(GenericService.getClientStreamMethod(), responseObserver);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(GenericService.getServiceDescriptor()).addMethod(GenericService.getEmptyResponseHandle(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(GenericService.getHandleNonEmptyResponse(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(GenericService.getClientStreamMethod(), ServerCalls.asyncClientStreamingCall(new MethodHandlers(this, 3))).build();
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final AnyServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(AnyServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    this.serviceImpl.handleEmptyResponse((Any)request, responseObserver);
                    break;
                }
                case 2: {
                    this.serviceImpl.handleNonEmptyResponse((Any)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 3: {
                    return this.serviceImpl.clientStream(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    private static final class AnyServiceMethodDescriptorSupplier
    extends AnyServiceBaseDescriptorSupplier
    implements ProtoMethodDescriptorSupplier {
        private final String methodName;

        AnyServiceMethodDescriptorSupplier(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public Descriptors.MethodDescriptor getMethodDescriptor() {
            return this.getServiceDescriptor().findMethodByName(this.methodName);
        }
    }

    private static final class AnyServiceFileDescriptorSupplier
    extends AnyServiceBaseDescriptorSupplier {
        AnyServiceFileDescriptorSupplier() {
        }
    }

    private static abstract class AnyServiceBaseDescriptorSupplier
    implements ProtoFileDescriptorSupplier,
    ProtoServiceDescriptorSupplier {
        AnyServiceBaseDescriptorSupplier() {
        }

        @Override
        public Descriptors.FileDescriptor getFileDescriptor() {
            return null;
        }

        @Override
        public Descriptors.ServiceDescriptor getServiceDescriptor() {
            return this.getFileDescriptor().findServiceByName(serviceName);
        }
    }
}

