/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.source;

import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.extension.io.grpc.source.AbstractGrpcSource;
import io.siddhi.extension.io.grpc.util.GrpcUtils;
import java.util.Map;

public class GrpcWorkerThread
implements Runnable {
    private AbstractGrpcSource relevantSource;
    private Object payload;
    private Map<String, String> headers;
    private Map<String, String> metaData;

    public GrpcWorkerThread(AbstractGrpcSource relevantSource, String payload, Map<String, String> headers, Map<String, String> metaData) {
        this.relevantSource = relevantSource;
        this.payload = payload;
        this.headers = headers;
        this.metaData = metaData;
    }

    public GrpcWorkerThread(AbstractGrpcSource relevantSource, Object payload, Map<String, String> headers, Map<String, String> metaData) {
        this.relevantSource = relevantSource;
        this.payload = payload;
        this.headers = headers;
        this.metaData = metaData;
    }

    @Override
    public void run() {
        try {
            String[] headersArray = GrpcUtils.extractHeaders(this.headers, this.metaData, this.relevantSource.getRequestedTransportPropertyNames());
            this.relevantSource.handleInjection(this.payload, headersArray);
        }
        catch (SiddhiAppRuntimeException e) {
            this.relevantSource.logError("Dropping request. " + e.getMessage());
        }
    }
}

