/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.grpc.sink;

import com.google.protobuf.GeneratedMessageV3;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.transport.DynamicOptions;
import io.siddhi.core.util.transport.Option;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.grpc.util.GrpcSourceRegistry;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import org.apache.log4j.Logger;

@Extension(name="grpc-service-response", namespace="sink", description="This extension is used to send responses back to a gRPC client after receiving requests through grpc-service source. This correlates with the particular source using a unique source.id", parameters={@Parameter(name="source.id", description="A unique id to identify the correct source to which this sink is mapped. There is a 1:1 mapping between source and sink", type={DataType.INT})}, examples={@Example(syntax="@sink(type='grpc-service-response',\n      source.id='1',\n      @map(type='json'))\ndefine stream BarStream (messageId String, message String);\n\n@source(type='grpc-service',\n        url='grpc://134.23.43.35:8080/org.wso2.grpc.EventService/process',\n        source.id='1',\n        @map(type='json',\n             @attributes(messageId='trp:messageId', message='message')))\ndefine stream FooStream (messageId String, message String);\nfrom FooStream\nselect * \ninsert into BarStream;\n", description="The grpc requests are received through the grpc-service sink. Each received event is sent back through grpc-service-source. This is just a passthrough through Siddhi as we are selecting everything from FooStream and inserting into BarStream.")})
public class GrpcServiceResponseSink
extends Sink {
    private static final Logger logger = Logger.getLogger((String)GrpcServiceResponseSink.class.getName());
    protected GrpcSourceRegistry grpcSourceRegistry = GrpcSourceRegistry.getInstance();
    private String sourceId;
    private Option messageIdOption;

    protected StateFactory init(StreamDefinition outputStreamDefinition, OptionHolder optionHolder, ConfigReader sinkConfigReader, SiddhiAppContext siddhiAppContext) {
        String streamID = outputStreamDefinition.getId();
        if (optionHolder.isOptionExists("source.id")) {
            this.sourceId = optionHolder.validateAndGetOption("source.id").getValue();
        } else if (optionHolder.validateAndGetOption("type").getValue().equalsIgnoreCase("grpc-service-response")) {
            throw new SiddhiAppValidationException(siddhiAppContext.getName() + ":" + streamID + ": For grpc-service-response sink the parameter source.id is mandatory for receiving responses. Please provide a source.id");
        }
        this.messageIdOption = optionHolder.validateAndGetOption("message.id");
        return null;
    }

    public void publish(Object payload, DynamicOptions dynamicOptions, State state) {
        String messageId = this.messageIdOption.getValue(dynamicOptions);
        this.grpcSourceRegistry.getGrpcServiceSource(this.sourceId).handleCallback(messageId, payload);
    }

    public void connect() throws ConnectionUnavailableException {
    }

    public void disconnect() {
    }

    public void destroy() {
    }

    public Class[] getSupportedInputEventClasses() {
        return new Class[]{String.class, GeneratedMessageV3.class};
    }

    protected ServiceDeploymentInfo exposeServiceDeploymentInfo() {
        return null;
    }

    public String[] getSupportedDynamicOptions() {
        return new String[]{"message.id"};
    }
}

