/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.sink.updatetoken;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.siddhi.extension.io.http.sink.updatetoken.DefaultListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public class HttpRequest {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequest.class);

    public static ArrayList<String> sendPostRequest(HttpClientConnector httpClientConnector, String serverScheme, String serverHost, int serverPort, String serverPath, String payload, Map<String, String> headers) {
        ArrayList<String> responses = new ArrayList<String>();
        HttpCarbonMessage msg = HttpRequest.createHttpPostReq(serverScheme, serverHost, serverPort, serverPath, payload);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            msg.setHeader(entry.getKey(), entry.getValue());
        }
        CountDownLatch latch = new CountDownLatch(1);
        DefaultListener listener = new DefaultListener(latch, "oauth");
        HttpResponseFuture responseFuture = httpClientConnector.send(msg);
        responseFuture.setHttpConnectorListener((HttpConnectorListener)listener);
        try {
            boolean latchCount = latch.await(30L, TimeUnit.SECONDS);
            if (!latchCount) {
                LOG.debug("Time out due to getting new access token. ");
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Time out due to getting new access token. " + e);
        }
        HttpCarbonMessage response = listener.getHttpResponseMessage();
        String statusCode = Integer.toString(response.getNettyHttpResponse().status().code());
        responses.add(statusCode);
        InputStream httpMessageDataStreamer = new HttpMessageDataStreamer(response).getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(httpMessageDataStreamer, Charset.defaultCharset());
        try (BufferedReader buffer = new BufferedReader(inputStreamReader);){
            String responsePayload = buffer.lines().collect(Collectors.joining("\n"));
            responses.add(responsePayload);
        }
        catch (IOException e) {
            LOG.debug("There was an error in reading the file while generating new access token. " + e);
        }
        return responses;
    }

    private static HttpCarbonMessage createHttpPostReq(String serverScheme, String serverHost, int serverPort, String serverPath, String payload) {
        HttpCarbonMessage httpPostRequest = new HttpCarbonMessage((HttpMessage)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, serverPath));
        httpPostRequest.setProperty("PROTOCOL", (Object)serverScheme);
        httpPostRequest.setProperty("host", (Object)serverHost);
        httpPostRequest.setProperty("port", (Object)serverPort);
        httpPostRequest.setProperty("TO", (Object)serverPath);
        httpPostRequest.setHttpMethod("POST");
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload.getBytes(Charset.forName("UTF-8")));
        httpPostRequest.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((ByteBuffer)byteBuffer)));
        return httpPostRequest;
    }
}

