/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.sink.updatetoken;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.siddhi.extension.io.http.sink.updatetoken.AccessTokenCache;
import io.siddhi.extension.io.http.sink.updatetoken.HttpRequest;
import io.siddhi.extension.io.http.sink.util.HttpSinkUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;

public class HttpsClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpsClient.class);
    private AccessTokenCache accessTokenCache = AccessTokenCache.getInstance();
    private Map<String, String> tokenURLProperties;

    private static SenderConfiguration getSenderConfigurationForHttp(String trustStorePath, String trustStorePassword) {
        SenderConfiguration senderConfiguration = new SenderConfiguration();
        senderConfiguration.setTrustStoreFile(trustStorePath);
        senderConfiguration.setTrustStorePass(trustStorePassword);
        senderConfiguration.setScheme("https");
        senderConfiguration.setHostNameVerificationEnabled(false);
        return senderConfiguration;
    }

    private static String encodeMessage(Object s) {
        try {
            return URLEncoder.encode((String)s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to encode the message while generating new access token: " + e);
            return "";
        }
    }

    private static String getPayload(Map<String, String> refreshTokenBody) {
        return refreshTokenBody.entrySet().stream().map(p -> HttpsClient.encodeMessage(p.getKey()) + "=" + HttpsClient.encodeMessage(p.getValue())).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
    }

    private static HashMap<String, String> setHeaders(String encodedAuth) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", encodedAuth);
        headers.put("Content-Type", String.valueOf(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED));
        return headers;
    }

    public void getPasswordGrantAccessToken(String tokenUrl, String trustStorePath, String trustStorePassword, String username, String password, String encodedAuth) {
        this.tokenURLProperties = HttpSinkUtil.getURLProperties(tokenUrl);
        DefaultHttpWsConnectorFactory factory = new DefaultHttpWsConnectorFactory();
        HttpClientConnector httpClientConnector = factory.createHttpClientConnector(new HashMap(), HttpsClient.getSenderConfigurationForHttp(trustStorePath, trustStorePassword));
        HashMap<String, String> refreshTokenBody = new HashMap<String, String>();
        refreshTokenBody.put("grant_type", "password");
        refreshTokenBody.put("username", username);
        refreshTokenBody.put("password", password);
        String payload = HttpsClient.getPayload(refreshTokenBody);
        HashMap<String, String> headers = HttpsClient.setHeaders(encodedAuth);
        ArrayList<String> response = HttpRequest.sendPostRequest(httpClientConnector, this.tokenURLProperties.get("PROTOCOL"), this.tokenURLProperties.get("host"), Integer.parseInt(this.tokenURLProperties.get("port")), this.tokenURLProperties.get("path"), payload, headers);
        JSONObject jsonObject = new JSONObject(response.get(1));
        int statusCode = Integer.parseInt(response.get(0));
        if (statusCode == 200) {
            String accessToken = jsonObject.getString("access_token");
            String newRefreshToken = jsonObject.getString("refresh_token");
            this.accessTokenCache.setAccessToken(encodedAuth, "Bearer " + accessToken);
            this.accessTokenCache.setRefreshtoken(encodedAuth, newRefreshToken);
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        } else {
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        }
        factory.shutdownNow();
    }

    public void getRefreshGrantAccessToken(String url, String trustStorePath, String trustStorePassword, String encodedAuth, String refreshToken) {
        this.tokenURLProperties = HttpSinkUtil.getURLProperties(url);
        DefaultHttpWsConnectorFactory factory = new DefaultHttpWsConnectorFactory();
        HttpClientConnector httpClientConnector = factory.createHttpClientConnector(new HashMap(), HttpsClient.getSenderConfigurationForHttp(trustStorePath, trustStorePassword));
        HashMap<String, String> refreshTokenBody = new HashMap<String, String>();
        HashMap<String, String> headers = HttpsClient.setHeaders(encodedAuth);
        refreshTokenBody.put("grant_type", "refresh_token");
        refreshTokenBody.put("refresh_token", refreshToken);
        String payload = HttpsClient.getPayload(refreshTokenBody);
        ArrayList<String> response = HttpRequest.sendPostRequest(httpClientConnector, this.tokenURLProperties.get("PROTOCOL"), this.tokenURLProperties.get("host"), Integer.parseInt(this.tokenURLProperties.get("port")), this.tokenURLProperties.get("path"), payload, headers);
        int statusCode = Integer.parseInt(response.get(0));
        JSONObject jsonObject = new JSONObject(response.get(1));
        if (statusCode == 200) {
            String accessToken = jsonObject.getString("access_token");
            String newRefreshToken = jsonObject.getString("refresh_token");
            this.accessTokenCache.setAccessToken(encodedAuth, "Bearer " + accessToken);
            this.accessTokenCache.setRefreshtoken(encodedAuth, newRefreshToken);
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        } else if (statusCode == 401 || statusCode == 400) {
            this.getClientGrantAccessToken(url, trustStorePath, trustStorePassword, encodedAuth);
        } else {
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        }
        factory.shutdownNow();
    }

    public void getClientGrantAccessToken(String url, String trustStorePath, String trustStorePassword, String encodedAuth) {
        this.tokenURLProperties = HttpSinkUtil.getURLProperties(url);
        DefaultHttpWsConnectorFactory factory = new DefaultHttpWsConnectorFactory();
        HttpClientConnector httpClientConnector = factory.createHttpClientConnector(new HashMap(), HttpsClient.getSenderConfigurationForHttp(trustStorePath, trustStorePassword));
        HashMap<String, String> refreshTokenBody = new HashMap<String, String>();
        refreshTokenBody.put("grant_type", "client_credentials");
        String payload = HttpsClient.getPayload(refreshTokenBody);
        HashMap<String, String> headers = HttpsClient.setHeaders(encodedAuth);
        ArrayList<String> response = HttpRequest.sendPostRequest(httpClientConnector, this.tokenURLProperties.get("PROTOCOL"), this.tokenURLProperties.get("host"), Integer.parseInt(this.tokenURLProperties.get("port")), this.tokenURLProperties.get("path"), payload, headers);
        JSONObject jsonObject = new JSONObject(response.get(1));
        int statusCode = Integer.parseInt(response.get(0));
        if (statusCode == 200) {
            String accessToken = jsonObject.getString("access_token");
            this.accessTokenCache.setAccessToken(encodedAuth, "Bearer " + accessToken);
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        } else {
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        }
        factory.shutdownNow();
    }
}

