/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.sink.util;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.http.sink.exception.HttpSinkAdaptorRuntimeException;
import io.siddhi.extension.io.http.util.HttpIoUtil;
import io.siddhi.extension.io.http.util.TrpPropertyTypes;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.carbon.messaging.Header;
import org.wso2.transport.http.netty.contract.config.ProxyServerConfiguration;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolConfiguration;

public class HttpSinkUtil {
    private static final Logger log = Logger.getLogger(HttpSinkUtil.class);

    private HttpSinkUtil() {
    }

    public static Map<String, String> getURLProperties(String publisherURL) {
        HashMap<String, String> httpStaticProperties;
        try {
            URL url = new URL(publisherURL);
            httpStaticProperties = new HashMap<String, String>();
            httpStaticProperties.put("TO", url.getFile());
            String protocol = url.getProtocol();
            String path = url.getPath();
            httpStaticProperties.put("PROTOCOL", protocol);
            httpStaticProperties.put("host", url.getHost());
            httpStaticProperties.put("path", path);
            int port = "https".equalsIgnoreCase(protocol) ? (url.getPort() != -1 ? url.getPort() : 443) : (url.getPort() != -1 ? url.getPort() : 80);
            httpStaticProperties.put("port", Integer.toString(port));
            httpStaticProperties.put("REQUEST_URL", url.toString());
        }
        catch (MalformedURLException e) {
            throw new HttpSinkAdaptorRuntimeException(" Receiver url mandatory. Please insert valid url .", e);
        }
        return httpStaticProperties;
    }

    public static List<Header> getHeaders(String headers) {
        if (headers != null) {
            headers = headers.trim();
            headers = headers.substring(1, headers.length() - 1);
            ArrayList<Header> headersList = new ArrayList<Header>();
            if (!"".equals(headers)) {
                String[] spam;
                for (String headerValue : spam = headers.split("','")) {
                    String[] header = headerValue.split(":", 2);
                    if (header.length <= 1) {
                        throw new HttpSinkAdaptorRuntimeException("Invalid header format. Please include as 'key1:value1','key2:value2',..");
                    }
                    headersList.add(new Header(header[0], header[1]));
                }
            }
            return headersList;
        }
        return null;
    }

    public static String trustStorePath(ConfigReader sinkConfigReader) {
        return sinkConfigReader.readConfig("trustStoreLocation", "${carbon.home}/resources/security/client-truststore.jks");
    }

    public static String trustStorePassword(ConfigReader sinkConfigReader) {
        return sinkConfigReader.readConfig("trustStorePassword", "wso2carbon");
    }

    public static SenderConfiguration getSenderConfigurations(Map<String, String> httpStaticProperties, String clientStoreFile, String clientStorePass, ConfigReader configReader) {
        SenderConfiguration httpSender = new SenderConfiguration(httpStaticProperties.get("port"));
        if (httpStaticProperties.get("PROTOCOL").equals("https")) {
            httpSender.setTrustStoreFile(clientStoreFile);
            httpSender.setTrustStorePass(clientStorePass);
            httpSender.setId(httpStaticProperties.get("TO"));
            httpSender.setScheme(httpStaticProperties.get("PROTOCOL"));
        } else {
            httpSender.setScheme(httpStaticProperties.get("PROTOCOL"));
        }
        if (HttpSinkUtil.isHTTPTraceLoggerEnabled(configReader)) {
            httpSender.setHttpTraceLogEnabled(true);
        }
        return httpSender;
    }

    private static boolean isHTTPTraceLoggerEnabled(ConfigReader configReader) {
        return Boolean.parseBoolean(configReader.readConfig("httpTraceLogEnabled", "false"));
    }

    public static Map<String, Object> populateTransportConfiguration(String clientBootstrapConfigurationList) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (!"".equals(clientBootstrapConfigurationList.trim())) {
            String[] valueList = clientBootstrapConfigurationList.trim().substring(1, clientBootstrapConfigurationList.length() - 1).split("','");
            properties.putAll(HttpSinkUtil.populateClientConnectionConfiguration(HttpIoUtil.populateParameterMap(valueList)));
        }
        return properties;
    }

    public static String getContentType(String mapType, List<Header> headersList) {
        if (headersList != null) {
            for (Header h : headersList) {
                if (!"Content-Type".equalsIgnoreCase(h.getName())) continue;
                return h.getValue();
            }
        }
        switch (mapType) {
            case "text": {
                return "text/plain";
            }
            case "xml": {
                return "application/xml";
            }
            case "json": {
                return "application/json";
            }
            case "keyvalue": {
                return "application/x-www-form-urlencoded";
            }
        }
        log.info((Object)"Invalid payload map type. System support only text,Json and XML type hence proceed with default text mapping");
        return "text/plain";
    }

    public static String getScheme(String senderUrl) {
        URL aURL;
        try {
            aURL = new URL(senderUrl);
        }
        catch (MalformedURLException e) {
            throw new SiddhiAppCreationException("SenderUrl is not in a proper format ", (Throwable)e);
        }
        return aURL.getProtocol();
    }

    private static Map<String, Object> populateClientConnectionConfiguration(Map<String, String> clientConnectionConfigurationList) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Map<String, TrpPropertyTypes> tryMap = HttpSinkUtil.trpPropertyTypeMap();
        clientConnectionConfigurationList.forEach((key, value) -> {
            switch (((TrpPropertyTypes)((Object)((Object)tryMap.get(key)))).name()) {
                case "BOOLEAN": {
                    properties.put((String)key, Boolean.valueOf(value));
                    break;
                }
                case "STRING": {
                    properties.put((String)key, value);
                    break;
                }
                case "INTEGER": {
                    properties.put((String)key, Integer.valueOf(value));
                    break;
                }
                case "DOUBLE": {
                    properties.put((String)key, Double.valueOf(value));
                    break;
                }
                default: {
                    log.error((Object)("Transport property:'" + ((TrpPropertyTypes)((Object)((Object)tryMap.get(key)))).name() + "' is no defined."));
                }
            }
        });
        return properties;
    }

    private static Map<String, TrpPropertyTypes> trpPropertyTypeMap() {
        HashMap<String, TrpPropertyTypes> trpPropertyTypes = new HashMap<String, TrpPropertyTypes>();
        trpPropertyTypes.put("client.bootstrap.nodelay", TrpPropertyTypes.BOOLEAN);
        trpPropertyTypes.put("client.bootstrap.keepalive", TrpPropertyTypes.BOOLEAN);
        trpPropertyTypes.put("client.bootstrap.sendbuffersize", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("client.bootstrap.recievebuffersize", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("client.bootstrap.connect.timeout", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("client.bootstrap.socket.reuse", TrpPropertyTypes.BOOLEAN);
        trpPropertyTypes.put("client.bootstrap.socket.timeout", TrpPropertyTypes.INTEGER);
        return trpPropertyTypes;
    }

    public static PoolConfiguration createPoolConfigurations(OptionHolder optionHolder) {
        int maxIdlePerPool = Integer.parseInt(optionHolder.validateAndGetStaticValue("max.pool.idle.connections", "100"));
        int minIdlePerPool = Integer.parseInt(optionHolder.validateAndGetStaticValue("min.pool.idle.connections", "0"));
        int maxActivePerPool = Integer.parseInt(optionHolder.validateAndGetStaticValue("max.pool.active.connections", "-1"));
        boolean testOnBorrow = Boolean.parseBoolean(optionHolder.validateAndGetStaticValue("test.on.borrow", "true"));
        boolean testWhileIdle = Boolean.parseBoolean(optionHolder.validateAndGetStaticValue("test.while.idle", "true"));
        long timeBetweenEvictionRuns = Long.parseLong(optionHolder.validateAndGetStaticValue("time.between.eviction.runs", "30000"));
        long minEvictableIdleTime = Long.parseLong(optionHolder.validateAndGetStaticValue("min.evictable.idle.time", "300000"));
        byte exhaustedAction = (byte)Integer.parseInt(optionHolder.validateAndGetStaticValue("exhausted.action", "1"));
        int maxWaitTime = Integer.parseInt(optionHolder.validateAndGetStaticValue("max.wait.time", "60000"));
        PoolConfiguration connectionPoolConfiguration = new PoolConfiguration();
        connectionPoolConfiguration.setMaxActivePerPool(maxActivePerPool);
        connectionPoolConfiguration.setMinIdlePerPool(minIdlePerPool);
        connectionPoolConfiguration.setMaxIdlePerPool(maxIdlePerPool);
        connectionPoolConfiguration.setTestOnBorrow(testOnBorrow);
        connectionPoolConfiguration.setTestWhileIdle(testWhileIdle);
        connectionPoolConfiguration.setTimeBetweenEvictionRuns(timeBetweenEvictionRuns);
        connectionPoolConfiguration.setMinEvictableIdleTime(minEvictableIdleTime);
        connectionPoolConfiguration.setExhaustedAction(exhaustedAction);
        connectionPoolConfiguration.setMaxWaitTime((long)maxWaitTime);
        return connectionPoolConfiguration;
    }

    public static DefaultHttpWsConnectorFactory createConnectorFactory(ConfigReader configReader) {
        String bootstrapWorker = configReader.readConfig("clientBootstrapWorkerGroupSize", "");
        String bootstrapBoss = configReader.readConfig("clientBootstrapBossGroupSize", "");
        String bootstrapClient = configReader.readConfig("clientBootstrapClientGroupSize", "");
        if (!"".equals(bootstrapBoss) && !"".equals(bootstrapWorker)) {
            if (!"".equals(bootstrapClient)) {
                return new DefaultHttpWsConnectorFactory(Integer.parseInt(bootstrapBoss), Integer.parseInt(bootstrapWorker), Integer.parseInt(bootstrapClient));
            }
            return new DefaultHttpWsConnectorFactory(Integer.parseInt(bootstrapBoss), Integer.parseInt(bootstrapWorker), Integer.parseInt(bootstrapWorker));
        }
        return new DefaultHttpWsConnectorFactory();
    }

    public static ProxyServerConfiguration createProxyServerConfiguration(OptionHolder optionHolder, String streamID, String appName) {
        String proxyHost = optionHolder.validateAndGetStaticValue("proxy.host", "");
        String proxyPort = optionHolder.validateAndGetStaticValue("proxy.port", "");
        String proxyUsername = optionHolder.validateAndGetStaticValue("proxy.username", "");
        String proxyPassword = optionHolder.validateAndGetStaticValue("proxy.password", "");
        if (!"".equals(proxyHost) && !"".equals(proxyPort)) {
            try {
                ProxyServerConfiguration proxyServerConfiguration = new ProxyServerConfiguration(proxyHost, Integer.parseInt(proxyPort));
                if (!"".equals(proxyPassword) && !"".equals(proxyUsername)) {
                    proxyServerConfiguration.setProxyPassword(proxyPassword);
                    proxyServerConfiguration.setProxyUsername(proxyUsername);
                }
            }
            catch (UnknownHostException e) {
                log.error((Object)("Proxy url of sink defined in '" + streamID + "' of Siddhi App '" + appName + "' is invalid."), (Throwable)e);
            }
        }
        return null;
    }
}

