/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.extension.io.http.source.HttpAuthenticator;
import io.siddhi.extension.io.http.source.HttpWorkerThread;
import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorRuntimeException;
import io.siddhi.extension.io.http.source.util.HttpSourceUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpSourceListener {
    private static final Logger logger = LoggerFactory.getLogger(HttpSourceListener.class);
    protected ExecutorService executorService;
    protected boolean paused;
    protected ReentrantLock lock;
    protected Condition condition;
    protected String url;
    protected Boolean isAuthEnabled;
    protected SourceEventListener sourceEventListener;
    protected String[] requestedTransportPropertyNames;
    private String siddhiAppName;

    protected HttpSourceListener(int workerThread, String url, Boolean auth, SourceEventListener sourceEventListener, String[] requestedTransportPropertyNames, String siddhiAppName) {
        this.executorService = Executors.newFixedThreadPool(workerThread);
        this.siddhiAppName = siddhiAppName;
        this.paused = false;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.url = url;
        this.isAuthEnabled = auth;
        this.sourceEventListener = sourceEventListener;
        this.requestedTransportPropertyNames = requestedTransportPropertyNames;
    }

    public String getSiddhiAppName() {
        return this.siddhiAppName;
    }

    protected void send(HttpCarbonMessage carbonMessage) {
        if (this.paused) {
            this.lock.lock();
            try {
                while (this.paused) {
                    this.condition.await();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                logger.error("Thread interrupted while pausing ", (Throwable)ie);
                HttpSourceUtil.handleCallback(carbonMessage, 500);
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.isAuthEnabled.booleanValue() && !HttpAuthenticator.authenticate(carbonMessage)) {
            throw new HttpSourceAdaptorRuntimeException(carbonMessage, "Authorisation fails", 401);
        }
        String[] trpProperties = new String[this.requestedTransportPropertyNames.length];
        this.populateTransportHeaders(carbonMessage, trpProperties);
        this.populateTransportProperties(carbonMessage, trpProperties);
        this.executorService.execute(new HttpWorkerThread(carbonMessage, this.sourceEventListener, this.sourceEventListener.getStreamDefinition().toString(), trpProperties));
    }

    protected void populateTransportHeaders(HttpCarbonMessage carbonMessage, String[] properties) {
        if (this.requestedTransportPropertyNames.length > 0) {
            int i = 0;
            for (String property : this.requestedTransportPropertyNames) {
                String value = carbonMessage.getHeader(property);
                if (value != null) {
                    properties[i] = value;
                }
                ++i;
            }
        }
    }

    protected void populateTransportProperties(HttpCarbonMessage carbonMessage, String[] properties) {
        if (this.requestedTransportPropertyNames.length > 0) {
            int i = 0;
            for (String property : this.requestedTransportPropertyNames) {
                Object value = carbonMessage.getProperty(property);
                if (value != null) {
                    properties[i] = String.valueOf(value);
                }
                ++i;
            }
        }
    }

    boolean isRunning() {
        return !this.paused;
    }

    boolean isPaused() {
        return this.paused;
    }

    void pause() {
        this.lock.lock();
        try {
            this.paused = true;
            logger.info("Event input has paused for " + this.url);
        }
        finally {
            this.lock.unlock();
        }
    }

    void resume() {
        this.lock.lock();
        try {
            this.paused = false;
            logger.info("Event input has resume for " + this.url);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void disconnect() {
        this.executorService.shutdown();
    }
}

