/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.extension.io.http.source.util.HttpSourceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public class HttpWorkerThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HttpWorkerThread.class);
    private HttpCarbonMessage carbonMessage;
    private SourceEventListener sourceEventListener;
    private String sourceID;
    private String[] trpProperties;

    HttpWorkerThread(HttpCarbonMessage cMessage, SourceEventListener sourceEventListener, String sourceID, String[] trpProperties) {
        this.carbonMessage = cMessage;
        this.sourceEventListener = sourceEventListener;
        this.sourceID = sourceID;
        this.trpProperties = trpProperties;
    }

    @Override
    public void run() {
        BufferedReader buf = new BufferedReader(new InputStreamReader(new HttpMessageDataStreamer(this.carbonMessage).getInputStream(), Charset.defaultCharset()));
        try {
            String payload = buf.lines().collect(Collectors.joining("\n"));
            if (!payload.equals("")) {
                this.sourceEventListener.onEvent((Object)payload, this.trpProperties);
                HttpSourceUtil.handleCallback(this.carbonMessage, 200);
                if (logger.isDebugEnabled()) {
                    logger.debug("Submitted Event " + payload + " Stream");
                }
            } else {
                HttpSourceUtil.handleCallback(this.carbonMessage, 405);
                if (logger.isDebugEnabled()) {
                    logger.debug("Empty payload event, hence dropping the event chunk at source " + this.sourceID);
                }
            }
        }
        finally {
            try {
                buf.close();
            }
            catch (IOException e) {
                logger.error("Error occurred when closing the byte buffer in source " + this.sourceID, (Throwable)e);
            }
        }
    }
}

