/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source.util;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorRuntimeException;
import io.siddhi.extension.io.http.util.HttpIoUtil;
import io.siddhi.extension.io.http.util.TrpPropertyTypes;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;
import org.wso2.transport.http.netty.contract.config.TransportProperty;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpSourceUtil {
    private static final Logger log = Logger.getLogger(HttpSourceUtil.class);

    private HttpSourceUtil() {
    }

    public static Set<TransportProperty> populateTransportProperties(Map<String, String> serverHeaderValidationList, Set<TransportProperty> transportProperties) {
        serverHeaderValidationList.forEach((key, value) -> transportProperties.add(HttpSourceUtil.getTransportProperty(key, value)));
        return transportProperties;
    }

    private static TransportProperty getTransportProperty(String name, String value) {
        TransportProperty trpProperty = new TransportProperty();
        Map<String, TrpPropertyTypes> tryMap = HttpSourceUtil.trpPropertyTypeMap();
        trpProperty.setName(name);
        switch (tryMap.get(name).name()) {
            case "BOOLEAN": {
                trpProperty.setValue((Object)Boolean.valueOf(value));
                break;
            }
            case "STRING": {
                trpProperty.setValue((Object)value);
                break;
            }
            case "INTEGER": {
                trpProperty.setValue((Object)Integer.valueOf(value));
                break;
            }
            case "DOUBLE": {
                trpProperty.setValue((Object)Double.valueOf(value));
                break;
            }
            default: {
                trpProperty.setValue((Object)value);
            }
        }
        return trpProperty;
    }

    public static Set<TransportProperty> populateBootstrapConfigurations(Map<String, String> serverBootstrapConfigurationList, Set<TransportProperty> transportProperties) {
        serverBootstrapConfigurationList.forEach((key, value) -> transportProperties.add(HttpSourceUtil.getTransportProperty(key, value)));
        return transportProperties;
    }

    public static String getSourceListenerKey(String listenerUrl) {
        URL aURL;
        try {
            aURL = new URL(listenerUrl);
        }
        catch (MalformedURLException e) {
            throw new SiddhiAppCreationException("ListenerUrl is not in a proper format ", (Throwable)e);
        }
        return String.valueOf(aURL.getPort()) + "-" + aURL.getPath();
    }

    public static String getPort(String listenerUrl) {
        URL aURL;
        try {
            aURL = new URL(listenerUrl);
        }
        catch (MalformedURLException e) {
            throw new SiddhiAppCreationException("ListenerUrl is not in a proper format ", (Throwable)e);
        }
        return String.valueOf(aURL.getPort());
    }

    public static ListenerConfiguration getListenerConfiguration(String listenerUrl, ConfigReader sourceConfigReader) {
        ListenerConfiguration listenerConfig = new ListenerConfiguration();
        try {
            URL aURL = new URL(listenerUrl);
            String protocol = aURL.getProtocol();
            String host = aURL.getHost();
            int port = aURL.getPort();
            switch (protocol) {
                case "http": {
                    listenerConfig = new ListenerConfiguration("http", host, port);
                    listenerConfig.setId(host + ":" + port);
                    listenerConfig.setScheme(protocol);
                    listenerConfig.setMessageProcessorId(sourceConfigReader.readConfig("messageProcessorId", "Siddhi HTTP-message-processor"));
                    break;
                }
                case "https": {
                    listenerConfig = new ListenerConfiguration("https", host, port);
                    listenerConfig.setId(host + ":" + port);
                    listenerConfig.setScheme(protocol);
                    listenerConfig.setKeyStoreFile(sourceConfigReader.readConfig("keyStoreLocation", "${carbon.home}/resources/security/wso2carbon.jks"));
                    listenerConfig.setKeyStorePass(sourceConfigReader.readConfig("keyStorePassword", "wso2carbon"));
                    listenerConfig.setMessageProcessorId(sourceConfigReader.readConfig("messageProcessorId", "Siddhi HTTP-message-processor"));
                    break;
                }
                default: {
                    throw new HttpSourceAdaptorRuntimeException("Invalid protocol " + protocol);
                }
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)("Receiver url malformed." + listenerUrl), (Throwable)e);
        }
        return listenerConfig;
    }

    public static void handleCallback(HttpCarbonMessage carbonMessage, int code) {
        HttpIoUtil.handleFailure(carbonMessage, null, code, null);
    }

    private static Map<String, TrpPropertyTypes> trpPropertyTypeMap() {
        HashMap<String, TrpPropertyTypes> trpPropertyTypes = new HashMap<String, TrpPropertyTypes>();
        trpPropertyTypes.put("latency.metrics.enabled", TrpPropertyTypes.BOOLEAN);
        trpPropertyTypes.put("request.size.validation", TrpPropertyTypes.BOOLEAN);
        trpPropertyTypes.put("request.size.validation.maximum.value", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("request.size.validation.reject.status.code", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("request.size.validation.reject.message", TrpPropertyTypes.STRING);
        trpPropertyTypes.put("request.size.validation.reject.message.content.type", TrpPropertyTypes.STRING);
        trpPropertyTypes.put("header.size.validation", TrpPropertyTypes.BOOLEAN);
        trpPropertyTypes.put("header.validation.maximum.request.line", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("header.validation.maximum.size", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("header.validation.maximum.chunk.size", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("header.validation.reject.status.code", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("header.validation.reject.message", TrpPropertyTypes.STRING);
        trpPropertyTypes.put("header.validation.reject.message.content.type", TrpPropertyTypes.STRING);
        trpPropertyTypes.put("server.bootstrap.nodelay", TrpPropertyTypes.BOOLEAN);
        trpPropertyTypes.put("server.bootstrap.keepalive", TrpPropertyTypes.BOOLEAN);
        trpPropertyTypes.put("server.bootstrap.sendbuffersize", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("server.bootstrap.recievebuffersize", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("server.bootstrap.connect.timeout", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("server.bootstrap.socket.timeout", TrpPropertyTypes.INTEGER);
        trpPropertyTypes.put("server.bootstrap.socket.backlog", TrpPropertyTypes.INTEGER);
        return trpPropertyTypes;
    }

    public static void handleCORS(HttpCarbonMessage requestMessage) {
        HttpIoUtil.handleResponse(requestMessage, HttpIoUtil.createOptionsResponseMessage(requestMessage));
    }
}

