/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.util;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorRuntimeException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.transport.http.netty.contract.config.Parameter;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpIoUtil {
    private static final Logger log = Logger.getLogger(HttpIoUtil.class);

    public static void handleResponse(HttpCarbonMessage requestMsg, HttpCarbonMessage responseMsg) {
        try {
            requestMsg.respond(responseMsg);
        }
        catch (ServerConnectorException e) {
            throw new HttpSourceAdaptorRuntimeException("Error occurred during response", e);
        }
    }

    public static void handleFailure(HttpCarbonMessage requestMessage, HttpSourceAdaptorRuntimeException ex, Integer code, String payload) {
        String responsePayload;
        int statusCode = code == null ? 500 : code;
        String string = responsePayload = payload != null ? payload : "";
        if (statusCode == 404 && ex != null) {
            responsePayload = ex.getMessage();
            log.error((Object)responsePayload, (Throwable)ex);
        }
        HttpIoUtil.handleResponse(requestMessage, HttpIoUtil.createErrorMessage(responsePayload, statusCode));
    }

    private static HttpCarbonMessage createErrorMessage(String responseValue, int statusCode) {
        HttpCarbonMessage response = HttpIoUtil.createHttpCarbonMessage();
        if (responseValue != null) {
            byte[] array;
            try {
                array = responseValue.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpSourceAdaptorRuntimeException("Error sending response.", e);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(array.length);
            byteBuffer.put(array);
            response.setHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(array.length));
            byteBuffer.flip();
            response.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((ByteBuffer)byteBuffer)));
        }
        response.setHttpStatusCode(Integer.valueOf(statusCode));
        response.setProperty("DIRECTION", (Object)"DIRECTION_RESPONSE");
        return response;
    }

    public static HttpCarbonMessage createOptionsResponseMessage(HttpCarbonMessage request) {
        HttpCarbonMessage response = HttpIoUtil.createHttpCarbonMessage();
        response.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(0))));
        response.setHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(0));
        response.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), request.getHeader(HttpHeaderNames.ORIGIN.toString()));
        response.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), "POST");
        response.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString(), String.format("%s,%s,%s,%s,%s", HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderNames.USER_AGENT.toString(), HttpHeaderNames.ORIGIN.toString(), HttpHeaderNames.REFERER.toString(), HttpHeaderNames.ACCEPT.toString()));
        response.setHttpStatusCode(Integer.valueOf(Integer.parseInt("200")));
        response.setProperty("DIRECTION", (Object)"DIRECTION_RESPONSE");
        return response;
    }

    public static HttpCarbonMessage createHttpCarbonMessage() {
        HttpCarbonMessage httpCarbonMessage = new HttpCarbonMessage((HttpMessage)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
        return httpCarbonMessage;
    }

    public static List<Parameter> populateParameters(String parameterList) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (!"".equals(parameterList.trim())) {
            String[] valueList = parameterList.trim().substring(1, parameterList.length() - 1).split("','");
            Arrays.stream(valueList).forEach(valueEntry -> {
                Parameter parameter = new Parameter();
                String[] entry = valueEntry.split(":");
                if (entry.length == 2) {
                    parameter.setName(entry[0]);
                    parameter.setValue(entry[1]);
                    parameters.add(parameter);
                } else {
                    log.error((Object)"Bootstrap configuration is not in expected format please insert them as 'key1:val1','key2:val2' format in http source.");
                }
            });
        }
        return parameters;
    }

    public static Map<String, String> populateParameterMap(String[] valueList) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Arrays.stream(valueList).forEach(valueEntry -> {
            String[] entry = valueEntry.split(":");
            if (entry.length == 2) {
                parameterMap.put(entry[0], entry[1]);
            } else {
                log.error((Object)("Configuration parameter '" + valueEntry + "' is not in expected format. Please insert them as 'key:val' format"));
            }
        });
        return parameterMap;
    }
}

