/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.metrics;

import io.siddhi.extension.io.http.metrics.EndpointStatus;
import io.siddhi.extension.io.http.metrics.Metrics;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

public class SinkMetrics
extends Metrics {
    public SinkMetrics(String siddhiAppName, String streamName) {
        super(siddhiAppName, streamName);
    }

    public Counter getTotalWritesMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Total.Writes.%s", this.siddhiAppName, "http"), Level.INFO, new Level[0]);
    }

    public Counter getTotalHttpWritesMetric(String url) {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Sink.Total.Writes.%s.%s", this.siddhiAppName, this.streamName, url), Level.INFO, new Level[0]);
    }

    public Counter getTotalHttpErrorsMetric(String url) {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Sink.Total.Errors.%s.%s", this.siddhiAppName, this.streamName, url), Level.INFO, new Level[0]);
    }

    public Counter getRequestSizeMetric(String url) {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Sink.Total.Request.Size.%s.%s", this.siddhiAppName, this.streamName, url), Level.INFO, new Level[0]);
    }

    public void setLatencyMetric(String url, long latency) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Sink.Average.Latency.%s.%s", this.siddhiAppName, this.streamName, url), Level.INFO, () -> latency);
    }

    public void setEndpointStatusMetric(String url, EndpointStatus status) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Sink.Endpoint.Status.%s.%s", this.siddhiAppName, this.streamName, url), Level.INFO, status::ordinal);
    }

    public void setLastEventTime(String url, long lastEventTime) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Sink.Last.Event.Time.%s.%s", this.siddhiAppName, this.streamName, url), Level.INFO, () -> lastEventTime);
    }
}

