/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.metrics;

import io.siddhi.extension.io.http.metrics.EndpointStatus;
import io.siddhi.extension.io.http.metrics.Metrics;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

public class SourceMetrics
extends Metrics {
    private final String url;

    public SourceMetrics(String siddhiAppName, String streamName, String url) {
        super(siddhiAppName, streamName);
        this.url = url;
    }

    public Counter getTotalReadsMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Total.Reads.%s", this.siddhiAppName, "http"), Level.INFO, new Level[0]);
    }

    public Counter getTotalHttpReadsMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Source.Total.Reads.%s.%s", this.siddhiAppName, this.streamName, this.url), Level.INFO, new Level[0]);
    }

    public Counter getTotalHttpErrorsMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Source.Total.Errors.%s.%s", this.siddhiAppName, this.streamName, this.url), Level.INFO, new Level[0]);
    }

    public Counter getRequestSizeMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Source.Total.Request.Size.%s.%s", this.siddhiAppName, this.streamName, this.url), Level.INFO, new Level[0]);
    }

    public void setEndpointStatusMetric(EndpointStatus status) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Source.Endpoint.Status.%s.%s", this.siddhiAppName, this.streamName, this.url), Level.INFO, status::ordinal);
    }

    public void setLastEventTime(long lastEventTime) {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Http.Source.Last.Event.Time.%s.%s", this.siddhiAppName, this.streamName, this.url), Level.INFO, () -> lastEventTime);
    }
}

