/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.extension.io.http.source.HttpConnectorRegistry;
import io.siddhi.extension.io.http.source.HttpSourceListener;
import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorRuntimeException;
import io.siddhi.extension.io.http.source.util.HttpSourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.config.TransportsConfiguration;
import org.wso2.transport.http.netty.contract.exceptions.ClientClosedConnectionException;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HTTPConnectorListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(HTTPConnectorListener.class);
    private TransportsConfiguration configuration;
    private HttpClientConnector clientConnector;

    public HTTPConnectorListener(TransportsConfiguration configuration) {
        this.configuration = configuration;
    }

    public HTTPConnectorListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onMessage(HttpCarbonMessage carbonMessage) {
        try {
            if (this.isValidRequest(carbonMessage)) {
                if (carbonMessage.getProperty("DIRECTION") != null && carbonMessage.getProperty("DIRECTION").equals("DIRECTION_RESPONSE")) {
                    try {
                        carbonMessage.respond(carbonMessage);
                        return;
                    }
                    catch (ServerConnectorException e) {
                        log.error("Error occurred during message notification: " + e.getMessage(), (Throwable)e);
                    }
                    return;
                } else if ("POST".equalsIgnoreCase(carbonMessage.getHttpMethod())) {
                    StringBuilder sourceListenerKey = new StringBuilder().append(String.valueOf(carbonMessage.getProperty("LISTENER_PORT"))).append("-").append(carbonMessage.getProperty("TO"));
                    HttpSourceListener sourceListener = this.getSourceListener(sourceListenerKey);
                    if (sourceListener != null) {
                        sourceListener.send(carbonMessage);
                        return;
                    } else {
                        HttpSourceUtil.handleCallback(carbonMessage, 404);
                    }
                    return;
                } else {
                    if (!"OPTIONS".equalsIgnoreCase(carbonMessage.getHttpMethod())) throw new HttpSourceAdaptorRuntimeException(carbonMessage, "Request type is not a type of POST ", 400);
                    HttpSourceUtil.handleCORS(carbonMessage);
                }
                return;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Event is not type of http which has received to the uri '" + String.valueOf(carbonMessage.getProperty("LISTENER_PORT")) + carbonMessage.getProperty("TO"));
                }
                HttpSourceUtil.handleCallback(carbonMessage, 404);
            }
            return;
        }
        finally {
            carbonMessage.waitAndReleaseAllEntities();
        }
    }

    protected boolean isValidRequest(HttpCarbonMessage carbonMessage) {
        return "http".equals(carbonMessage.getProperty("PROTOCOL")) && HttpConnectorRegistry.getInstance().getServerConnectorPool().containsKey(this.getInterface(carbonMessage));
    }

    protected HttpSourceListener getSourceListener(StringBuilder sourceListenerKey) {
        return HttpConnectorRegistry.getInstance().getSourceListenersMap().get(sourceListenerKey.toString());
    }

    protected String getInterface(HttpCarbonMessage cMsg) {
        String interfaceId = (String)cMsg.getProperty("listener.interface.id");
        if (interfaceId == null) {
            if (log.isDebugEnabled()) {
                log.debug("Interface id not found on the message, hence using the default interface");
            }
            interfaceId = "0.0.0.0:8280";
        }
        return interfaceId;
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof ClientClosedConnectionException) {
            log.debug("Error in http server connector", throwable);
        } else {
            log.error("Error in http server connector", throwable);
        }
    }
}

