/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.channel.pool;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contractimpl.common.HttpRoute;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.sender.channel.BootstrapConfiguration;
import org.wso2.transport.http.netty.contractimpl.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolConfiguration;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolableTargetChannelFactory;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolableTargetChannelFactoryPerSrcHndlr;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ConnectionManager;

public class ConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionManager.class);
    private final String connectionManagerId;
    private final PoolConfiguration poolConfiguration;
    private final Map<String, GenericObjectPool> globalConnPool;
    private final Map<String, PoolableTargetChannelFactory> globalFactoryObjects;
    private final Http2ConnectionManager http2ConnectionManager;

    public ConnectionManager(PoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
        this.globalConnPool = new ConcurrentHashMap<String, GenericObjectPool>();
        this.globalFactoryObjects = new ConcurrentHashMap<String, PoolableTargetChannelFactory>();
        this.http2ConnectionManager = new Http2ConnectionManager(poolConfiguration);
        this.connectionManagerId = "-" + UUID.randomUUID().toString();
    }

    public TargetChannel borrowTargetChannel(HttpRoute httpRoute, SourceHandler sourceHandler, Http2SourceHandler http2SourceHandler, SenderConfiguration senderConfig, BootstrapConfiguration bootstrapConfig, EventLoopGroup clientEventGroup) throws Exception {
        GenericObjectPool trgHlrConnPool;
        String trgHlrConnPoolId = httpRoute.toString() + this.connectionManagerId;
        if (sourceHandler != null) {
            ChannelHandlerContext inboundChannelContext = sourceHandler.getInboundChannelContext();
            trgHlrConnPool = this.getTrgHlrPoolFromGlobalPoolWithSrcPool(httpRoute, senderConfig, bootstrapConfig, trgHlrConnPoolId, inboundChannelContext.channel().eventLoop(), inboundChannelContext.channel().getClass(), sourceHandler.getTargetChannelPool());
        } else if (http2SourceHandler != null) {
            ChannelHandlerContext inboundChannelContext = http2SourceHandler.getInboundChannelContext();
            trgHlrConnPool = this.getTrgHlrPoolFromGlobalPoolWithSrcPool(httpRoute, senderConfig, bootstrapConfig, trgHlrConnPoolId, inboundChannelContext.channel().eventLoop(), inboundChannelContext.channel().getClass(), http2SourceHandler.getTargetChannelPool());
        } else {
            trgHlrConnPool = this.getTrgHlrPoolFromGlobalPool(httpRoute, senderConfig, bootstrapConfig, clientEventGroup);
        }
        return this.getTargetChannel(sourceHandler, http2SourceHandler, trgHlrConnPool, trgHlrConnPoolId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericObjectPool getTrgHlrPoolFromGlobalPool(HttpRoute httpRoute, SenderConfiguration senderConfig, BootstrapConfiguration bootstrapConfig, EventLoopGroup clientEventGroup) {
        GenericObjectPool trgHlrConnPool;
        Class<NioSocketChannel> eventLoopClass = NioSocketChannel.class;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (!this.globalConnPool.containsKey(httpRoute.toString())) {
                this.createTrgHlrPoolInGlobalPool(httpRoute, senderConfig, bootstrapConfig, clientEventGroup, eventLoopClass);
            }
            trgHlrConnPool = this.globalConnPool.get(httpRoute.toString());
        }
        return trgHlrConnPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericObjectPool getTrgHlrPoolFromGlobalPoolWithSrcPool(HttpRoute httpRoute, SenderConfiguration senderConfig, BootstrapConfiguration bootstrapConfig, String trgHlrConnPoolId, EventLoopGroup clientEventGroup, Class eventLoopClass, Map<String, GenericObjectPool> srcHlrConnPool) {
        GenericObjectPool trgHlrConnPool = srcHlrConnPool.get(trgHlrConnPoolId);
        if (trgHlrConnPool == null) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (!this.globalConnPool.containsKey(httpRoute.toString())) {
                    this.createTrgHlrPoolInGlobalPool(httpRoute, senderConfig, bootstrapConfig, clientEventGroup, eventLoopClass);
                }
                trgHlrConnPool = this.globalConnPool.get(httpRoute.toString());
                PoolableTargetChannelFactory channelFactory = this.globalFactoryObjects.get(httpRoute.toString());
                trgHlrConnPool = this.createPoolForRoutePerSrcHndlr(trgHlrConnPool, channelFactory, clientEventGroup, eventLoopClass);
            }
            srcHlrConnPool.put(trgHlrConnPoolId, trgHlrConnPool);
        }
        return trgHlrConnPool;
    }

    private void createTrgHlrPoolInGlobalPool(HttpRoute httpRoute, SenderConfiguration senderConfig, BootstrapConfiguration bootstrapConfig, EventLoopGroup clientEventGroup, Class eventLoopClass) {
        PoolableTargetChannelFactory poolableTargetChannelFactory = new PoolableTargetChannelFactory(clientEventGroup, eventLoopClass, httpRoute, senderConfig, bootstrapConfig, this);
        GenericObjectPool trgHlrConnPool = this.createPoolForRoute(poolableTargetChannelFactory);
        this.globalConnPool.put(httpRoute.toString(), trgHlrConnPool);
        this.globalFactoryObjects.put(httpRoute.toString(), poolableTargetChannelFactory);
    }

    private TargetChannel getTargetChannel(SourceHandler sourceHandler, Http2SourceHandler http2SourceHandler, GenericObjectPool trgHlrConnPool, String trgHlrConnPoolId) throws Exception {
        TargetChannel targetChannel = (TargetChannel)trgHlrConnPool.borrowObject();
        if (sourceHandler != null) {
            targetChannel.setCorrelatedSource(sourceHandler);
        } else if (http2SourceHandler != null) {
            targetChannel.setCorrelatedSource(http2SourceHandler);
        } else {
            targetChannel.setCorrelatedSource(null);
        }
        targetChannel.setConnectionManager(this);
        targetChannel.trgHlrConnPoolId = trgHlrConnPoolId;
        return targetChannel;
    }

    public void returnChannel(TargetChannel targetChannel) throws Exception {
        if (targetChannel.getCorrelatedSource() != null) {
            Map<String, GenericObjectPool> objectPoolMap = this.getTargetPoolMap(targetChannel);
            if (objectPoolMap != null) {
                this.releaseChannelToPool(targetChannel, objectPoolMap.get(targetChannel.trgHlrConnPoolId));
            }
        } else {
            this.releaseChannelToPool(targetChannel, this.globalConnPool.get(targetChannel.getHttpRoute().toString()));
        }
    }

    private void releaseChannelToPool(TargetChannel targetChannel, GenericObjectPool pool) throws Exception {
        try {
            String channelID = targetChannel.getChannel().id().asShortText();
            if (targetChannel.getChannel().isActive() && pool != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Returning connection {} to the pool", (Object)channelID);
                }
                pool.returnObject((Object)targetChannel);
            } else {
                LOG.debug("Channel {} is inactive hence not returning to connection pool", (Object)channelID);
            }
        }
        catch (Exception e) {
            throw new Exception("Couldn't return channel to pool", e);
        }
    }

    public void invalidateTargetChannel(TargetChannel targetChannel) throws Exception {
        Map<String, GenericObjectPool> objectPoolMap;
        if (targetChannel.getCorrelatedSource() != null && (objectPoolMap = this.getTargetPoolMap(targetChannel)) != null) {
            try {
                String poolId = targetChannel.trgHlrConnPoolId;
                if (objectPoolMap.containsKey(poolId)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Invalidating connection {} to the pool", (Object)targetChannel.getChannel().id().asShortText());
                    }
                    objectPoolMap.get(poolId).invalidateObject((Object)targetChannel);
                }
            }
            catch (Exception e) {
                throw new Exception("Cannot invalidate channel from pool", e);
            }
        }
    }

    private Map<String, GenericObjectPool> getTargetPoolMap(TargetChannel targetChannel) {
        Map<String, GenericObjectPool> objectPoolMap = null;
        ChannelInboundHandlerAdapter correlatedSource = targetChannel.getCorrelatedSource();
        if (correlatedSource instanceof SourceHandler) {
            SourceHandler h1SourceHandler = (SourceHandler)correlatedSource;
            objectPoolMap = h1SourceHandler.getTargetChannelPool();
        } else if (correlatedSource instanceof Http2SourceHandler) {
            Http2SourceHandler h2SourceHandler = (Http2SourceHandler)correlatedSource;
            objectPoolMap = h2SourceHandler.getTargetChannelPool();
        }
        return objectPoolMap;
    }

    public Http2ConnectionManager getHttp2ConnectionManager() {
        return this.http2ConnectionManager;
    }

    private GenericObjectPool createPoolForRoutePerSrcHndlr(GenericObjectPool genericObjectPool, PoolableTargetChannelFactory channelFactory, EventLoopGroup clientEventGroup, Class eventLoopClass) {
        return new GenericObjectPool((PoolableObjectFactory)new PoolableTargetChannelFactoryPerSrcHndlr(genericObjectPool, channelFactory, clientEventGroup, eventLoopClass), this.instantiateAndConfigureConfig());
    }

    private GenericObjectPool createPoolForRoute(PoolableTargetChannelFactory poolableTargetChannelFactory) {
        return new GenericObjectPool((PoolableObjectFactory)poolableTargetChannelFactory, this.instantiateAndConfigureConfig());
    }

    private GenericObjectPool.Config instantiateAndConfigureConfig() {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = this.poolConfiguration.getMaxActivePerPool();
        config.maxIdle = this.poolConfiguration.getMaxIdlePerPool();
        config.minIdle = this.poolConfiguration.getMinIdlePerPool();
        config.testOnBorrow = this.poolConfiguration.isTestOnBorrow();
        config.testWhileIdle = this.poolConfiguration.isTestWhileIdle();
        config.timeBetweenEvictionRunsMillis = this.poolConfiguration.getTimeBetweenEvictionRuns();
        config.minEvictableIdleTimeMillis = this.poolConfiguration.getMinEvictableIdleTime();
        config.whenExhaustedAction = this.poolConfiguration.getExhaustedAction();
        config.maxWait = this.poolConfiguration.getMaxWaitTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating a pool with {}", (Object)config);
        }
        return config;
    }
}

