/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.extension.io.http.source.HttpCallResponseConnectorListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class HttpCallResponseSourceConnectorRegistry {
    private static HttpCallResponseSourceConnectorRegistry instance = new HttpCallResponseSourceConnectorRegistry();
    private Map<String, HttpCallResponseConnectorListener> sourceListenersMap = new ConcurrentHashMap<String, HttpCallResponseConnectorListener>();

    private HttpCallResponseSourceConnectorRegistry() {
    }

    static HttpCallResponseSourceConnectorRegistry getInstance() {
        return instance;
    }

    Map<String, HttpCallResponseConnectorListener> getSourceListenersMap() {
        return this.sourceListenersMap;
    }

    void registerSourceListener(HttpCallResponseConnectorListener httpResponseSourceListener, String sinkId, String statusCode) {
        HttpCallResponseConnectorListener sourceListener = this.sourceListenersMap.putIfAbsent(sinkId + statusCode, httpResponseSourceListener);
        if (sourceListener != null) {
            throw new SiddhiAppCreationException("There is a connection already established for the source with sink.id : '" + sinkId + "' and http.status.code : '" + statusCode + "'.");
        }
    }

    void unregisterSourceListener(String sinkId, String statusCode, String siddhiAppName) {
        HttpCallResponseConnectorListener httpSourceListener = this.sourceListenersMap.get(sinkId + statusCode);
        if (httpSourceListener != null && httpSourceListener.getSiddhiAppName().equals(siddhiAppName)) {
            this.sourceListenersMap.remove(sinkId + statusCode);
            httpSourceListener.disconnect();
        }
    }
}

