/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.extension.io.http.metrics.EndpointStatus;
import io.siddhi.extension.io.http.metrics.SourceMetrics;
import io.siddhi.extension.io.http.source.ConnectorStartupSynchronizer;
import java.net.BindException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.PortBindingEventListener;

public class HttpConnectorPortBindingListener
implements PortBindingEventListener {
    private static final Logger log = LoggerFactory.getLogger(HttpConnectorPortBindingListener.class);
    private ConnectorStartupSynchronizer connectorStartupSynchronizer;
    private String serverConnectorId;
    private SourceMetrics metrics;

    public HttpConnectorPortBindingListener(ConnectorStartupSynchronizer connectorStartupSynchronizer, String serverConnectorId, SourceMetrics metrics) {
        this.connectorStartupSynchronizer = connectorStartupSynchronizer;
        this.serverConnectorId = serverConnectorId;
        this.metrics = metrics;
    }

    @Override
    public void onOpen(String serverConnectorId, boolean isHttps) {
        if (this.metrics != null) {
            this.metrics.setEndpointStatusMetric(EndpointStatus.ONLINE);
        }
        if (isHttps) {
            log.info("HTTPS source " + serverConnectorId + " has been started");
        } else {
            log.info("HTTP source " + serverConnectorId + " has been started");
        }
        this.connectorStartupSynchronizer.getCountDownLatch().countDown();
    }

    @Override
    public void onClose(String serverConnectorId, boolean isHttps) {
        if (this.metrics != null) {
            this.metrics.setEndpointStatusMetric(EndpointStatus.OFFLINE);
        }
        if (isHttps) {
            log.info("HTTPS source " + serverConnectorId + " has been closed");
        } else {
            log.info("HTTP source " + serverConnectorId + " has been closed");
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.metrics != null) {
            this.metrics.setEndpointStatusMetric(EndpointStatus.OFFLINE);
        }
        log.error("Error in http source ", throwable);
        if (throwable instanceof BindException) {
            this.connectorStartupSynchronizer.addException(this.serverConnectorId, (BindException)throwable);
            this.connectorStartupSynchronizer.getCountDownLatch().countDown();
        }
    }
}

