/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.util;

import io.siddhi.extension.io.http.source.HttpCallResponseSource;
import io.siddhi.extension.io.http.source.HttpServiceSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HTTPSourceRegistry {
    private static Map<String, HttpServiceSource> serviceSourceRegistry = new ConcurrentHashMap<String, HttpServiceSource>();
    private static Map<String, HttpCallResponseSource> callResponseSourceRegistry = new ConcurrentHashMap<String, HttpCallResponseSource>();

    public static HttpServiceSource getServiceSource(String sourceId) {
        return serviceSourceRegistry.get(sourceId);
    }

    public static void registerServiceSource(String sourceId, HttpServiceSource source) {
        serviceSourceRegistry.put(sourceId, source);
    }

    public static void removeServiceSource(String sourceId) {
        serviceSourceRegistry.remove(sourceId);
    }

    public static void registerCallResponseSource(String sinkId, String statusCode, HttpCallResponseSource source) {
        callResponseSourceRegistry.put(sinkId + statusCode, source);
    }

    public static void removeCallResponseSource(String sinkId, String statusCode) {
        callResponseSourceRegistry.remove(sinkId + statusCode);
    }

    public static HttpCallResponseSource findAndGetResponseSource(String sinkId, String statusCode) {
        for (HttpCallResponseSource responseSource : callResponseSourceRegistry.values()) {
            if (!responseSource.matches(sinkId, statusCode)) continue;
            return responseSource;
        }
        return null;
    }
}

