/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.ReceivingEntityBody;
import org.wso2.transport.http.netty.contractimpl.listener.states.Response100ContinueSent;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class Expect100ContinueHeaderReceived
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(Expect100ContinueHeaderReceived.class);
    private final ListenerReqRespStateManager listenerReqRespStateManager;
    private final SourceHandler sourceHandler;
    private final HttpCarbonMessage inboundRequestMsg;
    private final float httpVersion;

    Expect100ContinueHeaderReceived(ListenerReqRespStateManager listenerReqRespStateManager, SourceHandler sourceHandler, HttpCarbonMessage inboundRequestMsg, float httpVersion) {
        this.listenerReqRespStateManager = listenerReqRespStateManager;
        this.sourceHandler = sourceHandler;
        this.inboundRequestMsg = inboundRequestMsg;
        this.httpVersion = httpVersion;
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        this.listenerReqRespStateManager.state = new ReceivingEntityBody(this.listenerReqRespStateManager, this.inboundRequestMsg, this.sourceHandler, this.httpVersion);
        this.listenerReqRespStateManager.readInboundRequestBody(inboundRequestEntityBody);
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundResponseListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        this.listenerReqRespStateManager.state = Util.getHttpResponseStatus(outboundResponseMsg).code() == HttpResponseStatus.CONTINUE.code() ? new Response100ContinueSent(this.listenerReqRespStateManager, this.sourceHandler, outboundResponseListener) : new EntityBodyReceived(this.listenerReqRespStateManager, this.sourceHandler, this.httpVersion);
        this.listenerReqRespStateManager.writeOutboundResponseBody(outboundResponseListener, outboundResponseMsg, httpContent);
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Remote client closed the connection before initiating 100 continue response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", (Throwable)e);
        }
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Idle timeout triggered before initiating 100 continue response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", (Throwable)e);
        }
        String responseValue = "Server time out";
        ChannelFuture outboundRespFuture = this.sendRequestTimeoutResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer(responseValue, CharsetUtil.UTF_8), responseValue.length());
        outboundRespFuture.addListener(channelFuture -> {
            Throwable cause = channelFuture.cause();
            if (cause != null) {
                LOG.warn("Failed to send: {}", (Object)cause.getMessage());
            }
            ctx.close();
        });
        return outboundRespFuture;
    }

    private ChannelFuture sendRequestTimeoutResponse(ChannelHandlerContext ctx, HttpResponseStatus status, ByteBuf content, int length) {
        DefaultFullHttpResponse outboundResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        outboundResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)length);
        outboundResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        outboundResponse.headers().set(HttpHeaderNames.CONNECTION.toString(), (Object)"close");
        outboundResponse.headers().set(HttpHeaderNames.SERVER.toString(), (Object)this.sourceHandler.getServerName());
        return ctx.channel().writeAndFlush(outboundResponse);
    }
}

