/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.siddhi.extension.io.http.source.internal.HttpIODataHolder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(HttpAuthenticator.class);

    public static boolean authenticate(HttpCarbonMessage httpCarbonMessage) {
        if (HttpIODataHolder.getInstance().getBundleContext() == null) {
            return true;
        }
        String authHeader = httpCarbonMessage.getHeaders().get("Authorization");
        if (authHeader != null) {
            String usernamePasswordEncoded = authHeader.replace("Basic ", "");
            ByteBuf usernamePasswordBuf = Base64.decode(Unpooled.copiedBuffer(usernamePasswordEncoded.getBytes(Charset.defaultCharset())));
            String[] credentials = usernamePasswordBuf.toString(Charset.defaultCharset()).split(":");
            IdPClient idPClient = HttpIODataHolder.getInstance().getClient();
            if (idPClient != null && credentials.length == 2) {
                try {
                    HashMap<String, String> loginProperties = new HashMap<String, String>();
                    loginProperties.put("Username", credentials[0]);
                    loginProperties.put("Password", credentials[1]);
                    loginProperties.put("Grant_Type", "password");
                    Map login = idPClient.login(loginProperties);
                    String loginStatus = (String)login.get("Status");
                    if (loginStatus.equals("success")) {
                        return true;
                    }
                    logger.error("Authentication failed for username '" + credentials[0] + "'. Error : '" + (String)login.get("Error") + "'. Error Description : '" + (String)login.get("Error_Description") + "'");
                    return false;
                }
                catch (IdPClientException e) {
                    logger.error("Authorization process fails for user '" + credentials[0] + "'", (Throwable)e);
                    return false;
                }
            }
            logger.error("Authorization header in incorrect format. header: " + usernamePasswordEncoded);
            return false;
        }
        logger.error("Authorization header 'null' ");
        return false;
    }
}

