/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.util.transport.DynamicOptions;
import io.siddhi.extension.io.http.metrics.EndpointStatus;
import io.siddhi.extension.io.http.metrics.SinkMetrics;
import io.siddhi.extension.io.http.sink.HttpSink;
import io.siddhi.extension.io.http.source.HttpCallResponseConnectorListener;
import io.siddhi.extension.io.http.source.HttpCallResponseSource;
import io.siddhi.extension.io.http.util.HTTPSourceRegistry;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.exceptions.ClientConnectorException;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpResponseMessageListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(HttpResponseMessageListener.class);
    private Map<String, Object> trpProperties;
    private boolean isDownloadEnabled;
    private String sinkId;
    private HttpCarbonMessage carbonMessages;
    private CountDownLatch latch;
    private HttpSink sink;
    private final Object payload;
    private final DynamicOptions dynamicOptions;
    private String siddhiAppName;
    private String publisherURL;
    private SinkMetrics metrics;
    private long startTime;
    private long endTime;

    public HttpResponseMessageListener(HttpSink sink, Map<String, Object> trpProperties, String sinkId, boolean isDownloadEnabled, CountDownLatch latch, Object payload, DynamicOptions dynamicOptions, String siddhiAppName, String publisherURL, SinkMetrics metrics, long startTime) {
        this.trpProperties = trpProperties;
        this.isDownloadEnabled = isDownloadEnabled;
        this.sinkId = sinkId;
        this.latch = latch;
        this.sink = sink;
        this.payload = payload;
        this.dynamicOptions = dynamicOptions;
        this.siddhiAppName = siddhiAppName;
        this.publisherURL = publisherURL;
        this.metrics = metrics;
        this.startTime = startTime;
    }

    @Override
    public void onMessage(HttpCarbonMessage carbonMessage) {
        String statusCode;
        HttpCallResponseSource responseSource;
        this.endTime = System.currentTimeMillis();
        if (this.metrics != null) {
            this.metrics.setEndpointStatusMetric(this.publisherURL, EndpointStatus.ONLINE);
            this.metrics.setLatencyMetric(this.publisherURL, this.endTime - this.startTime);
            this.metrics.setLastEventTime(this.publisherURL, this.endTime);
            if (carbonMessage.getHttpStatusCode() / 100 != 2) {
                this.metrics.getTotalHttpErrorsMetric(this.publisherURL).inc();
            }
        }
        this.trpProperties.forEach((k, v) -> carbonMessage.setProperty((String)k, v));
        carbonMessage.setProperty("__is_downloadable_content", this.isDownloadEnabled);
        this.carbonMessages = carbonMessage;
        if (this.latch != null) {
            this.latch.countDown();
        }
        if ((responseSource = HTTPSourceRegistry.findAndGetResponseSource(this.sinkId, statusCode = Integer.toString(carbonMessage.getNettyHttpResponse().status().code()))) != null) {
            HttpCallResponseConnectorListener responseConnectorListener = responseSource.getConnectorListener();
            responseConnectorListener.onMessage(carbonMessage);
        } else {
            log.error("No source of type 'http-call-response' with sink.id '" + this.sinkId + "' for the status code '" + statusCode + "' defined. Hence dropping the response message.");
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.metrics != null) {
            this.metrics.getTotalHttpErrorsMetric(this.publisherURL).inc();
            this.metrics.setEndpointStatusMetric(this.publisherURL, EndpointStatus.OFFLINE);
        }
        if (throwable instanceof IOException) {
            this.sink.createClientConnector(null);
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
        if (throwable instanceof ClientConnectorException || throwable instanceof ServerConnectorException) {
            this.sink.onError(this.payload, this.dynamicOptions, (Exception)new ConnectionUnavailableException("HTTP call sink on stream '" + this.sink.getStreamDefinition().getId() + "' of Siddhi App '" + this.siddhiAppName + "' failed to publish events to endpoint '" + this.publisherURL + "'. " + throwable.getMessage(), throwable));
        } else {
            this.sink.onError(this.payload, this.dynamicOptions, (Exception)new SiddhiAppRuntimeException("HTTP call sink on stream '" + this.sink.getStreamDefinition().getId() + "' of Siddhi App '" + this.siddhiAppName + "' failed to publish events to endpoint '" + this.publisherURL + "'. " + throwable.getMessage(), throwable));
        }
    }

    public int getHttpResponseStatusCode() {
        if (this.carbonMessages != null) {
            return this.carbonMessages.getNettyHttpResponse().status().code();
        }
        return 408;
    }
}

