/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.siddhi.core.stream.input.source.SourceEventListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public class HttpResponseProcessor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseProcessor.class);
    boolean shouldAllowStreamingResponses;
    private HttpCarbonMessage carbonMessage;
    private SourceEventListener sourceEventListener;
    private String sinkId;
    private String[] trpProperties;
    private String filePath;

    HttpResponseProcessor(HttpCarbonMessage cMessage, SourceEventListener sourceEventListener, boolean shouldAllowStreamingResponses, String sinkId, String[] trpProperties) {
        this.carbonMessage = cMessage;
        this.sourceEventListener = sourceEventListener;
        this.sinkId = sinkId;
        this.trpProperties = trpProperties;
        this.shouldAllowStreamingResponses = shouldAllowStreamingResponses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block19: {
            try {
                HttpContent content;
                int code = this.carbonMessage.getNettyHttpResponse().status().code() / 100;
                boolean isDownloadableContent = (Boolean)this.carbonMessage.getProperty("__is_downloadable_content");
                if (isDownloadableContent && code == 2) {
                    this.filePath = this.carbonMessage.getProperty("download.path").toString();
                    String fileName = this.writeToTile(this.carbonMessage);
                    if (fileName != null) {
                        this.sourceEventListener.onEvent((Object)fileName, this.trpProperties);
                    }
                    break block19;
                }
                if (!this.shouldAllowStreamingResponses) {
                    BufferedReader buf = new BufferedReader(new InputStreamReader(new HttpMessageDataStreamer(this.carbonMessage).getInputStream(), Charset.defaultCharset()));
                    try {
                        String payload = buf.lines().collect(Collectors.joining("\n"));
                        if (!payload.equals("")) {
                            this.sourceEventListener.onEvent((Object)payload, this.trpProperties);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Submitted Event :" + payload);
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("Empty payload event, hence dropping the event chunk at source " + this.sinkId);
                        }
                        break block19;
                    }
                    finally {
                        try {
                            buf.close();
                        }
                        catch (IOException e) {
                            logger.error("Error occurred when closing the byte buffer in source " + this.sinkId, (Throwable)e);
                        }
                    }
                }
                do {
                    if ((content = this.carbonMessage.getHttpContent()) == null) continue;
                    String payload = content.content().toString(Charset.defaultCharset());
                    if (!payload.equals("")) {
                        this.sourceEventListener.onEvent((Object)payload, this.trpProperties);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Submitted Event :" + payload);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Empty payload event, hence dropping the event chunk in the source with sink.id : " + this.sinkId);
                } while (!(content instanceof LastHttpContent));
            }
            finally {
                this.carbonMessage.waitAndReleaseAllEntities();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String writeToTile(HttpCarbonMessage carbonMessage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

