/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.extension.io.http.metrics.SourceMetrics;
import io.siddhi.extension.io.http.source.HttpSSEResponseConnectorListener;
import io.siddhi.extension.io.http.source.HttpSSESource;
import io.siddhi.extension.io.http.util.HTTPSourceRegistry;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpSSEResponseListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(HttpSSEResponseListener.class);
    private String streamId;
    private CountDownLatch latch;
    private HttpSSESource source;
    private SourceMetrics metrics;

    public HttpSSEResponseListener(HttpSSESource source, String streamId, CountDownLatch latch, SourceMetrics metrics) {
        this.streamId = streamId;
        this.latch = latch;
        this.source = source;
        this.metrics = metrics;
    }

    @Override
    public void onMessage(HttpCarbonMessage carbonMessage) {
        HttpSSESource responseSource;
        carbonMessage.setProperty("__is_downloadable_content", false);
        if (this.latch != null) {
            this.latch.countDown();
        }
        if ((responseSource = HTTPSourceRegistry.findAndGetSSESource(this.streamId)) != null) {
            HttpSSEResponseConnectorListener responseConnectorListener = responseSource.getConnectorListener();
            responseConnectorListener.onMessage(carbonMessage);
        } else {
            log.error("No sse source is registered for the stream '" + this.streamId + "'. Hence dropping the response message.");
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof IOException) {
            this.source.createClientConnector();
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
    }
}

