/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.extension.io.http.source.HttpSSEResponseConnectorListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class HttpSSESourceConnectorRegistry {
    private static HttpSSESourceConnectorRegistry instance = new HttpSSESourceConnectorRegistry();
    private Map<String, HttpSSEResponseConnectorListener> sourceListenersMap = new ConcurrentHashMap<String, HttpSSEResponseConnectorListener>();

    private HttpSSESourceConnectorRegistry() {
    }

    static HttpSSESourceConnectorRegistry getInstance() {
        return instance;
    }

    Map<String, HttpSSEResponseConnectorListener> getSourceListenersMap() {
        return this.sourceListenersMap;
    }

    void registerSourceListener(HttpSSEResponseConnectorListener httpSSEResponseConnectorListener, String streamId) {
        HttpSSEResponseConnectorListener sourceListener = this.sourceListenersMap.putIfAbsent(streamId, httpSSEResponseConnectorListener);
        if (sourceListener != null) {
            throw new SiddhiAppCreationException("There is a connection already established for the sse source with stream id : '" + streamId + "'.");
        }
    }

    void unregisterSourceListener(String streamId, String siddhiAppName) {
        HttpSSEResponseConnectorListener httpSourceListener = this.sourceListenersMap.get(streamId);
        if (httpSourceListener != null && httpSourceListener.getSiddhiAppName().equals(siddhiAppName)) {
            this.sourceListenersMap.remove(streamId);
            httpSourceListener.disconnect();
        }
    }
}

