/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.EntityBodyState;
import org.wso2.transport.http.netty.message.EntityCollector;

public class BlockingEntityCollector
implements EntityCollector {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingEntityCollector.class);
    private int soTimeOut;
    private EntityBodyState state;
    private BlockingQueue<HttpContent> httpContentQueue;
    private Lock readWriteLock;
    private Condition readCondition;

    BlockingEntityCollector(int soTimeOut) {
        this.soTimeOut = soTimeOut;
        this.state = EntityBodyState.EXPECTING;
        this.readWriteLock = new ReentrantLock();
        this.httpContentQueue = new LinkedBlockingQueue<HttpContent>();
        this.readCondition = this.readWriteLock.newCondition();
    }

    @Override
    public void addHttpContent(HttpContent httpContent) {
        try {
            this.readWriteLock.lock();
            this.state = EntityBodyState.CONSUMABLE;
            this.httpContentQueue.add(httpContent);
            this.readCondition.signalAll();
        }
        catch (Exception e) {
            LOG.error("Cannot put content to queue", (Throwable)e);
        }
        finally {
            this.readWriteLock.unlock();
        }
    }

    @Override
    public void addMessageBody(ByteBuffer msgBody) {
        this.addHttpContent(new DefaultHttpContent(Unpooled.copiedBuffer(msgBody)));
    }

    @Override
    public HttpContent getHttpContent() {
        try {
            this.readWriteLock.lock();
            if (this.state == EntityBodyState.CONSUMABLE || this.state == EntityBodyState.EXPECTING) {
                this.waitForEntity();
                HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.MILLISECONDS);
                if (httpContent instanceof LastHttpContent) {
                    this.state = EntityBodyState.CONSUMED;
                    this.httpContentQueue.clear();
                }
                HttpContent httpContent2 = httpContent;
                return httpContent2;
            }
        }
        catch (InterruptedException e) {
            LOG.error("Error while retrieving http content from queue", (Throwable)e);
        }
        finally {
            this.readWriteLock.unlock();
        }
        return null;
    }

    @Override
    public ByteBuf getMessageBody() {
        HttpContent httpContent = this.getHttpContent();
        if (httpContent != null) {
            return httpContent.content();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFullMessageLength() {
        long size = 0L;
        try {
            this.readWriteLock.lock();
            ArrayList<HttpContent> contentList = new ArrayList<HttpContent>();
            while (this.state == EntityBodyState.CONSUMABLE || this.state == EntityBodyState.EXPECTING) {
                this.waitForEntity();
                HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.MILLISECONDS);
                size += (long)httpContent.content().readableBytes();
                contentList.add(httpContent);
                if (!(httpContent instanceof LastHttpContent)) continue;
                this.state = EntityBodyState.CONSUMED;
            }
            this.httpContentQueue.addAll(contentList);
            this.state = EntityBodyState.CONSUMABLE;
        }
        catch (InterruptedException e) {
            LOG.warn("Error while getting full message length", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Error while retrieving http content length", (Throwable)e);
        }
        finally {
            this.readWriteLock.unlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countMessageLengthTill(long maxSize) throws IllegalStateException {
        long size = 0L;
        try {
            this.readWriteLock.lock();
            ArrayList<HttpContent> contentList = new ArrayList<HttpContent>();
            while (this.state == EntityBodyState.CONSUMABLE || this.state == EntityBodyState.EXPECTING) {
                this.waitForEntity();
                HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.MILLISECONDS);
                if (httpContent == null) {
                    throw new IllegalStateException("poll timeout expired");
                }
                contentList.add(httpContent);
                if ((size += (long)httpContent.content().readableBytes()) >= maxSize) {
                    while (!this.httpContentQueue.isEmpty()) {
                        contentList.add(this.httpContentQueue.poll(this.soTimeOut, TimeUnit.MILLISECONDS));
                    }
                    break;
                }
                if (!(httpContent instanceof LastHttpContent)) continue;
                this.state = EntityBodyState.CONSUMED;
            }
            this.httpContentQueue.addAll(contentList);
            this.state = EntityBodyState.CONSUMABLE;
        }
        catch (InterruptedException e) {
            LOG.warn("Error while getting full message length", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.warn("Error while retrieving http content", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error while retrieving http content length", (Throwable)e);
        }
        finally {
            this.readWriteLock.unlock();
        }
        return size;
    }

    private void waitForEntity() throws InterruptedException {
        while (this.httpContentQueue.isEmpty() && this.readCondition.await(this.soTimeOut, TimeUnit.MILLISECONDS)) {
        }
    }

    @Override
    public void waitAndReleaseAllEntities() {
        try {
            this.readWriteLock.lock();
            if (this.state == EntityBodyState.CONSUMABLE) {
                boolean isEndOfMessageProcessed = false;
                while (!isEndOfMessageProcessed) {
                    this.waitForEntity();
                    HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.MILLISECONDS);
                    if (httpContent instanceof LastHttpContent) {
                        isEndOfMessageProcessed = true;
                        this.state = EntityBodyState.CONSUMED;
                        this.httpContentQueue.clear();
                    }
                    httpContent.release();
                }
            }
            this.state = EntityBodyState.EXPECTING;
        }
        catch (InterruptedException e) {
            LOG.error("Error while getting content from queue", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Error while waiting and releasing the content", (Throwable)e);
        }
        finally {
            this.readWriteLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.readWriteLock.lock();
            boolean bl = this.httpContentQueue.isEmpty();
            return bl;
        }
        finally {
            this.readWriteLock.unlock();
        }
    }

    @Override
    public void completeMessage() {
        try {
            this.readWriteLock.lock();
            if (this.state == EntityBodyState.EXPECTING) {
                this.addHttpContent(new DefaultLastHttpContent());
            }
        }
        finally {
            this.readWriteLock.unlock();
        }
    }
}

