/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.extension.io.http.metrics.SourceMetrics;
import io.siddhi.extension.io.http.source.ConnectorStartupSynchronizer;
import io.siddhi.extension.io.http.source.HTTPConnectorListener;
import io.siddhi.extension.io.http.source.HttpConnectorPortBindingListener;
import io.siddhi.extension.io.http.source.HttpSourceListener;
import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorRuntimeException;
import io.siddhi.extension.io.http.source.util.HttpSourceUtil;
import io.siddhi.extension.io.http.util.HttpIoUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.config.InboundMsgSizeValidationConfig;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;
import org.wso2.transport.http.netty.contract.config.ServerBootstrapConfiguration;
import org.wso2.transport.http.netty.contract.config.TransportProperty;
import org.wso2.transport.http.netty.contract.config.TransportsConfiguration;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;
import org.wso2.transport.http.netty.message.HttpConnectorUtil;

class HttpConnectorRegistry {
    private static HttpConnectorRegistry instance = new HttpConnectorRegistry();
    private final Logger log = Logger.getLogger(HttpConnectorRegistry.class);
    protected TransportsConfiguration trpConfig;
    protected DefaultHttpWsConnectorFactory httpConnectorFactory;
    private Map<String, HttpServerConnectorContext> serverConnectorPool = new ConcurrentHashMap<String, HttpServerConnectorContext>();
    private Map<String, HttpSourceListener> sourceListenersMap = new ConcurrentHashMap<String, HttpSourceListener>();

    protected HttpConnectorRegistry() {
    }

    static HttpConnectorRegistry getInstance() {
        return instance;
    }

    private static String getSeverConnectorKey(String listenerUrl) {
        URL aURL;
        try {
            aURL = new URL(listenerUrl);
        }
        catch (MalformedURLException e) {
            throw new SiddhiAppCreationException("Server connector is not in a proper format ", (Throwable)e);
        }
        return aURL.getHost() + ":" + String.valueOf(aURL.getPort());
    }

    InboundMsgSizeValidationConfig populateRequestSizeValidationConfiguration() {
        return new InboundMsgSizeValidationConfig();
    }

    void setTransportConfig(String serverBootstrapConfigurationList, String serverHeaderValidation) {
        String[] valueList;
        this.trpConfig = new TransportsConfiguration();
        HashSet<TransportProperty> transportProperties = new HashSet<TransportProperty>();
        if (!"".equals(serverBootstrapConfigurationList.trim())) {
            valueList = serverBootstrapConfigurationList.trim().substring(1, serverBootstrapConfigurationList.length() - 1).split("','");
            this.trpConfig.setTransportProperties(HttpSourceUtil.populateBootstrapConfigurations(HttpIoUtil.populateParameterMap(valueList), transportProperties));
        }
        if (!"".equals(serverHeaderValidation.trim())) {
            valueList = serverHeaderValidation.trim().substring(1, serverHeaderValidation.length() - 1).split("','");
            this.trpConfig.setTransportProperties(HttpSourceUtil.populateTransportProperties(HttpIoUtil.populateParameterMap(valueList), transportProperties));
        }
    }

    Map<String, HttpSourceListener> getSourceListenersMap() {
        return this.sourceListenersMap;
    }

    void registerSourceListener(SourceEventListener sourceEventListener, String listenerUrl, int workerThread, Boolean isAuth, String[] requestedTransportPropertyNames, String siddhiAppName, SourceMetrics metrics) {
        String listenerKey = HttpSourceUtil.getSourceListenerKey(listenerUrl, metrics);
        HttpSourceListener httpSourceListener = this.sourceListenersMap.putIfAbsent(listenerKey, new HttpSourceListener(workerThread, listenerUrl, isAuth, sourceEventListener, requestedTransportPropertyNames, siddhiAppName, metrics));
        if (httpSourceListener != null) {
            if (metrics != null) {
                metrics.getTotalHttpErrorsMetric().inc();
            }
            throw new SiddhiAppCreationException("Listener URL " + listenerUrl + " already connected");
        }
    }

    protected void unregisterSourceListener(String listenerUrl, String siddhiAppName, SourceMetrics metrics) {
        String key = HttpSourceUtil.getSourceListenerKey(listenerUrl, metrics);
        HttpSourceListener httpSourceListener = this.sourceListenersMap.get(key);
        if (httpSourceListener != null && httpSourceListener.getSiddhiAppName().equals(siddhiAppName)) {
            this.sourceListenersMap.remove(key);
            httpSourceListener.disconnect();
        }
    }

    protected synchronized void initBootstrapConfigIfFirst(ConfigReader sourceConfigReader) {
        if (this.sourceListenersMap.isEmpty() && this.httpConnectorFactory == null) {
            String bootstrapWorker = sourceConfigReader.readConfig("serverBootstrapWorkerGroupSize", "");
            String bootstrapBoss = sourceConfigReader.readConfig("serverBootstrapBossGroupSize", "");
            String bootstrapClient = sourceConfigReader.readConfig("serverBootstrapClientGroupSize", "");
            this.httpConnectorFactory = !"".equals(bootstrapBoss) && !"".equals(bootstrapWorker) ? (!"".equals(bootstrapClient) ? new DefaultHttpWsConnectorFactory(Integer.parseInt(bootstrapBoss), Integer.parseInt(bootstrapWorker), Integer.parseInt(bootstrapClient)) : new DefaultHttpWsConnectorFactory(Integer.parseInt(bootstrapBoss), Integer.parseInt(bootstrapWorker), Integer.parseInt(bootstrapWorker))) : new DefaultHttpWsConnectorFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearBootstrapConfigIfLast() {
        HttpConnectorRegistry httpConnectorRegistry = this;
        synchronized (httpConnectorRegistry) {
            if (this.sourceListenersMap.isEmpty() && this.httpConnectorFactory != null) {
                this.httpConnectorFactory.shutdownNow();
                this.httpConnectorFactory = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createHttpServerConnector(ListenerConfiguration listenerConfig, SourceMetrics metrics) {
        HttpConnectorRegistry httpConnectorRegistry = this;
        synchronized (httpConnectorRegistry) {
            String listenerInterface = listenerConfig.getHost() + ":" + listenerConfig.getPort();
            HttpServerConnectorContext httpServerConnectorContext = this.serverConnectorPool.get(listenerInterface);
            if (httpServerConnectorContext != null) {
                if (this.checkForConflicts(listenerConfig, httpServerConnectorContext)) {
                    if (metrics != null) {
                        metrics.getTotalHttpErrorsMetric().inc();
                    }
                    throw new HttpSourceAdaptorRuntimeException("Conflicting configuration detected for listener configuration id " + listenerConfig.getId());
                }
                httpServerConnectorContext.incrementReferenceCount();
                return;
            }
            ServerBootstrapConfiguration serverBootstrapConfiguration = HttpConnectorUtil.getServerBootstrapConfiguration(this.trpConfig.getTransportProperties());
            ServerConnector serverConnector = this.httpConnectorFactory.createServerConnector(serverBootstrapConfiguration, listenerConfig);
            httpServerConnectorContext = new HttpServerConnectorContext(serverConnector, listenerConfig);
            this.serverConnectorPool.put(serverConnector.getConnectorID(), httpServerConnectorContext);
            httpServerConnectorContext.incrementReferenceCount();
            this.registerServerConnector(serverConnector, listenerConfig, metrics);
        }
    }

    void registerServerConnector(ServerConnector serverConnector, ListenerConfiguration listenerConfig, SourceMetrics metrics) {
        ServerConnectorFuture connectorFuture = serverConnector.start();
        ConnectorStartupSynchronizer startupSyncer = new ConnectorStartupSynchronizer(new CountDownLatch(1));
        this.setConnectorListeners(connectorFuture, serverConnector.getConnectorID(), startupSyncer, metrics);
        try {
            startupSyncer.getCountDownLatch().await();
        }
        catch (InterruptedException e) {
            throw new HttpSourceAdaptorRuntimeException("Error in starting HTTP server connector for server: " + listenerConfig.getHost() + ":" + listenerConfig.getPort(), e);
        }
        this.validateConnectorStartup(startupSyncer);
    }

    Map<String, HttpServerConnectorContext> getServerConnectorPool() {
        return this.serverConnectorPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unregisterServerConnector(String listenerUrl) {
        String port = HttpSourceUtil.getPort(listenerUrl);
        HttpConnectorRegistry httpConnectorRegistry = this;
        synchronized (httpConnectorRegistry) {
            HttpServerConnectorContext context = this.serverConnectorPool.get(HttpConnectorRegistry.getSeverConnectorKey(listenerUrl));
            if (context != null) {
                if (context.getReferenceCount() == 1) {
                    this.serverConnectorPool.remove(HttpConnectorRegistry.getSeverConnectorKey(listenerUrl));
                    this.log.info((Object)("Server connector for port '" + port + "' has successfully shutdown."));
                    context.decrementReferenceCount();
                    return context.getServerConnector().stop();
                }
                context.decrementReferenceCount();
            }
            return false;
        }
    }

    private boolean checkForConflicts(ListenerConfiguration listenerConfiguration, HttpServerConnectorContext context) {
        if (context == null) {
            return false;
        }
        if (listenerConfiguration.getScheme().equalsIgnoreCase("https")) {
            ListenerConfiguration config = context.getListenerConfiguration();
            if (config.getScheme().equalsIgnoreCase("https")) {
                if (!listenerConfiguration.getKeyStoreFile().equals(config.getKeyStoreFile()) || !listenerConfiguration.getKeyStorePass().equals(config.getKeyStorePass())) {
                    this.log.info((Object)"There is already registered https server connector for same host:port which has  conflicting configurations.");
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected void setConnectorListeners(ServerConnectorFuture connectorFuture, String serverConnectorId, ConnectorStartupSynchronizer startupSyncer, SourceMetrics metrics) {
        connectorFuture.setHttpConnectorListener(new HTTPConnectorListener());
        connectorFuture.setPortBindingEventListener(new HttpConnectorPortBindingListener(startupSyncer, serverConnectorId, metrics));
    }

    private void validateConnectorStartup(ConnectorStartupSynchronizer startupSyncer) {
        int noOfExceptions = startupSyncer.getExceptions().size();
        if (noOfExceptions <= 0) {
            return;
        }
        startupSyncer.getExceptions().forEach((connectorId, e) -> this.log.error((Object)("siddhi: " + e.getMessage() + ": [" + connectorId + "]"), (Throwable)e));
        if (noOfExceptions == 1) {
            throw new HttpSourceAdaptorRuntimeException("failed to start the server connectors");
        }
    }

    private static class HttpServerConnectorContext {
        private ServerConnector serverConnector;
        private ListenerConfiguration listenerConfiguration;
        private int referenceCount = 0;

        public HttpServerConnectorContext(ServerConnector serverConnector, ListenerConfiguration listenerConfiguration) {
            this.serverConnector = serverConnector;
            this.listenerConfiguration = listenerConfiguration;
        }

        public void incrementReferenceCount() {
            ++this.referenceCount;
        }

        public void decrementReferenceCount() {
            --this.referenceCount;
        }

        public ServerConnector getServerConnector() {
            return this.serverConnector;
        }

        public ListenerConfiguration getListenerConfiguration() {
            return this.listenerConfiguration;
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }
    }
}

