/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.sink;

import io.siddhi.extension.io.http.sink.SSEConnectorRegistry;
import io.siddhi.extension.io.http.sink.SSERequestListener;
import io.siddhi.extension.io.http.source.HTTPConnectorListener;
import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorRuntimeException;
import io.siddhi.extension.io.http.source.util.HttpSourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.exceptions.ClientClosedConnectionException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SSEConnectorListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(HTTPConnectorListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onMessage(HttpCarbonMessage carbonMessage) {
        try {
            if (this.isValidRequest(carbonMessage)) {
                if ("GET".equalsIgnoreCase(carbonMessage.getHttpMethod()) || "POST".equalsIgnoreCase(carbonMessage.getHttpMethod())) {
                    StringBuilder sourceListenerKey = new StringBuilder().append(String.valueOf(carbonMessage.getProperty("LISTENER_PORT"))).append("-").append(carbonMessage.getProperty("TO"));
                    SSERequestListener requestListener = this.getSourceListener(sourceListenerKey);
                    if (requestListener != null) {
                        requestListener.send(carbonMessage);
                        return;
                    } else {
                        HttpSourceUtil.handleCallback(carbonMessage, 404);
                    }
                    return;
                } else {
                    if (!"OPTIONS".equalsIgnoreCase(carbonMessage.getHttpMethod())) throw new HttpSourceAdaptorRuntimeException(carbonMessage, "Request type is not a type of GET or POST ", 400);
                    HttpSourceUtil.handleCORS(carbonMessage);
                }
                return;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Event is not type of http which has received to the uri '" + String.valueOf(carbonMessage.getProperty("LISTENER_PORT")) + carbonMessage.getProperty("TO"));
                }
                HttpSourceUtil.handleCallback(carbonMessage, 404);
            }
            return;
        }
        finally {
            carbonMessage.waitAndReleaseAllEntities();
        }
    }

    protected boolean isValidRequest(HttpCarbonMessage carbonMessage) {
        return "http".equals(carbonMessage.getProperty("PROTOCOL")) && SSEConnectorRegistry.getInstance().getServerConnectorPool().containsKey(this.getInterface(carbonMessage));
    }

    protected SSERequestListener getSourceListener(StringBuilder sourceListenerKey) {
        return SSEConnectorRegistry.getInstance().getSourceListenersMap().get(sourceListenerKey.toString());
    }

    protected String getInterface(HttpCarbonMessage cMsg) {
        String interfaceId = (String)cMsg.getProperty("listener.interface.id");
        if (interfaceId == null) {
            if (log.isDebugEnabled()) {
                log.debug("Interface id not found on the message, hence using the default interface");
            }
            interfaceId = "0.0.0.0:8280";
        }
        return interfaceId;
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof ClientClosedConnectionException) {
            log.debug("Error in http server connector", throwable);
        } else {
            log.error("Error in http server connector", throwable);
        }
    }
}

