/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.sink;

import io.siddhi.extension.io.http.sink.SSEWorkerThread;
import io.siddhi.extension.io.http.source.HttpAuthenticator;
import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorRuntimeException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SSERequestListener {
    private static final Logger logger = LoggerFactory.getLogger(SSERequestListener.class);
    private ExecutorService executorService;
    private boolean paused;
    private ReentrantLock lock;
    private Condition condition;
    private String url;
    private Boolean isAuthEnabled;
    private String siddhiAppName;
    private String streamId;

    public SSERequestListener(int workerThread, String url, Boolean auth, String streamId, String siddhiAppName) {
        this.executorService = Executors.newFixedThreadPool(workerThread);
        this.siddhiAppName = siddhiAppName;
        this.paused = false;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.url = url;
        this.isAuthEnabled = auth;
        this.streamId = streamId;
    }

    protected void send(HttpCarbonMessage carbonMessage) {
        if (this.isAuthEnabled.booleanValue() && !HttpAuthenticator.authenticate(carbonMessage)) {
            throw new HttpSourceAdaptorRuntimeException(carbonMessage, "Authorisation fails", 401);
        }
        this.executorService.execute(new SSEWorkerThread(carbonMessage, this.streamId));
    }

    public String getSiddhiAppName() {
        return this.siddhiAppName;
    }

    void disconnect() {
        this.executorService.shutdown();
    }
}

