/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.sink;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.extension.io.http.sink.SSEConnectorRegistry;
import io.siddhi.extension.io.http.sink.SSERequestListener;
import io.siddhi.extension.io.http.sink.SSESyncConnectorListener;
import io.siddhi.extension.io.http.source.ConnectorStartupSynchronizer;
import io.siddhi.extension.io.http.source.HttpConnectorPortBindingListener;
import io.siddhi.extension.io.http.source.util.HttpSourceUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;

public class SSESyncConnectorRegistry
extends SSEConnectorRegistry {
    private static SSESyncConnectorRegistry instance = new SSESyncConnectorRegistry();
    private Map<String, SSERequestListener> sourceListenersMap = new ConcurrentHashMap<String, SSERequestListener>();

    private SSESyncConnectorRegistry() {
    }

    public static SSESyncConnectorRegistry getInstance() {
        return instance;
    }

    protected Map<String, SSERequestListener> getSyncSourceListenersMap() {
        return this.sourceListenersMap;
    }

    protected void registerSourceListener(String listenerUrl, int workerThread, Boolean isAuth, String sourceId, String siddhiAppName) {
        String listenerKey = HttpSourceUtil.getSourceListenerKey(listenerUrl, null);
        SSERequestListener httpSourceListener = this.sourceListenersMap.putIfAbsent(listenerKey, new SSERequestListener(workerThread, listenerUrl, isAuth, sourceId, siddhiAppName));
        if (httpSourceListener != null) {
            throw new SiddhiAppCreationException("Listener URL " + listenerUrl + " already connected");
        }
    }

    @Override
    protected void unregisterSourceListener(String listenerUrl, String siddhiAppName) {
        String key = HttpSourceUtil.getSourceListenerKey(listenerUrl, null);
        SSERequestListener httpSourceListener = this.sourceListenersMap.get(key);
        if (httpSourceListener != null && httpSourceListener.getSiddhiAppName().equals(siddhiAppName)) {
            this.sourceListenersMap.remove(key);
            httpSourceListener.disconnect();
        }
    }

    @Override
    protected synchronized void initBootstrapConfigIfFirst(ConfigReader sourceConfigReader) {
        if (this.sourceListenersMap.isEmpty() && this.httpConnectorFactory == null) {
            String bootstrapWorker = sourceConfigReader.readConfig("serverBootstrapWorkerGroupSize", "");
            String bootstrapBoss = sourceConfigReader.readConfig("serverBootstrapBossGroupSize", "");
            String bootstrapClient = sourceConfigReader.readConfig("serverBootstrapClientGroupSize", "");
            this.httpConnectorFactory = !"".equals(bootstrapBoss) && !"".equals(bootstrapWorker) ? (!"".equals(bootstrapClient) ? new DefaultHttpWsConnectorFactory(Integer.parseInt(bootstrapBoss), Integer.parseInt(bootstrapWorker), Integer.parseInt(bootstrapClient)) : new DefaultHttpWsConnectorFactory(Integer.parseInt(bootstrapBoss), Integer.parseInt(bootstrapWorker), Integer.parseInt(bootstrapWorker))) : new DefaultHttpWsConnectorFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearBootstrapConfigIfLast() {
        SSESyncConnectorRegistry sSESyncConnectorRegistry = this;
        synchronized (sSESyncConnectorRegistry) {
            if (this.sourceListenersMap.isEmpty() && this.httpConnectorFactory != null) {
                this.httpConnectorFactory.shutdownNow();
                this.httpConnectorFactory = null;
            }
        }
    }

    @Override
    protected void setConnectorListeners(ServerConnectorFuture connectorFuture, String serverConnectorId, ConnectorStartupSynchronizer startupSyncer) {
        connectorFuture.setHttpConnectorListener(new SSESyncConnectorListener());
        connectorFuture.setPortBindingEventListener(new HttpConnectorPortBindingListener(startupSyncer, serverConnectorId, null));
    }
}

