/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.sink.updatetoken;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.siddhi.extension.io.http.sink.updatetoken.AccessTokenCache;
import io.siddhi.extension.io.http.sink.updatetoken.HttpRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.OkHttpClient;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.Util;

public class HttpsClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpsClient.class);
    private AccessTokenCache accessTokenCache = AccessTokenCache.getInstance();

    private static String encodeMessage(Object s) {
        try {
            return URLEncoder.encode((String)s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to encode the message while generating new access token: " + e);
            return "";
        }
    }

    private static String getPayload(Map<String, String> refreshTokenBody) {
        return refreshTokenBody.entrySet().stream().map(p -> HttpsClient.encodeMessage(p.getKey()) + "=" + HttpsClient.encodeMessage(p.getValue())).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
    }

    private static HashMap<String, String> setHeaders(String encodedAuth) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", encodedAuth);
        headers.put("Content-Type", String.valueOf(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED));
        return headers;
    }

    private static OkHttpClient getOkHttpClient(String trustStorePath, String trustStorePassword) {
        try {
            KeyStore keyStore = HttpsClient.readKeyStore(trustStorePath, trustStorePassword);
            SSLContext sslContext = SSLContext.getInstance("SSL");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, "keystore_pass".toCharArray());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            return new OkHttpClient().newBuilder().sslSocketFactory(sslContext.getSocketFactory()).hostnameVerifier((host, sslSession) -> true).build();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            LOG.error("Error occurred while initializing the http client, Returning normal client", (Throwable)e);
            return new OkHttpClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore readKeyStore(String trustStorePath, String trustStorePassword) throws IOException, KeyStoreException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = trustStorePassword.toCharArray();
        try (FileInputStream fis = null;){
            File file = new File(Util.substituteVariables(trustStorePath));
            fis = new FileInputStream(file);
            ks.load(fis, password);
        }
        return ks;
    }

    public void getPasswordGrantAccessToken(String tokenUrl, String trustStorePath, String trustStorePassword, String username, String password, String encodedAuth, String consumerKey, String consumerSecret, String oAuth2Scope) {
        HashMap<String, String> refreshTokenBody = new HashMap<String, String>();
        refreshTokenBody.put("grant_type", "password");
        refreshTokenBody.put("username", username);
        refreshTokenBody.put("password", password);
        if (!"".equals(oAuth2Scope)) {
            refreshTokenBody.put("scope", oAuth2Scope);
        }
        if (!"".equals(consumerKey)) {
            refreshTokenBody.put("client_id", consumerKey);
        }
        if (!"".equals(consumerSecret)) {
            refreshTokenBody.put("client_secret", consumerSecret);
        }
        OkHttpClient client = HttpsClient.getOkHttpClient(trustStorePath, trustStorePassword);
        HashMap<String, String> headers = HttpsClient.setHeaders(encodedAuth);
        List<String> response = HttpRequest.getResponse(tokenUrl, encodedAuth, HttpsClient.getPayload(refreshTokenBody), client, headers);
        client.dispatcher().executorService().shutdown();
        JSONObject jsonObject = new JSONObject(response.get(1));
        int statusCode = Integer.parseInt(response.get(0));
        if (statusCode == 200) {
            String accessToken = jsonObject.getString("access_token");
            this.accessTokenCache.setAccessToken(encodedAuth, "Bearer " + accessToken);
            String newRefreshToken = jsonObject.getString("refresh_token");
            if (newRefreshToken != null) {
                this.accessTokenCache.setRefreshtoken(encodedAuth, newRefreshToken);
            }
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        } else {
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        }
    }

    public void getRefreshGrantAccessToken(String url, String trustStorePath, String trustStorePassword, String encodedAuth, String refreshToken, String oauthUsername, String oauthUserPassword, String bodyConsumerKey, String bodyConsumerSecret, String oauth2Scope) {
        HashMap<String, String> refreshTokenBody = new HashMap<String, String>();
        HashMap<String, String> headers = HttpsClient.setHeaders(encodedAuth);
        refreshTokenBody.put("grant_type", "refresh_token");
        refreshTokenBody.put("refresh_token", refreshToken);
        OkHttpClient client = HttpsClient.getOkHttpClient(trustStorePath, trustStorePassword);
        List<String> response = HttpRequest.getResponse(url, encodedAuth, HttpsClient.getPayload(refreshTokenBody), client, headers);
        client.dispatcher().executorService().shutdown();
        int statusCode = Integer.parseInt(response.get(0));
        JSONObject jsonObject = new JSONObject(response.get(1));
        if (statusCode == 200) {
            String accessToken = jsonObject.getString("access_token");
            String newRefreshToken = jsonObject.getString("refresh_token");
            this.accessTokenCache.setAccessToken(encodedAuth, "Bearer " + accessToken);
            this.accessTokenCache.setRefreshtoken(encodedAuth, newRefreshToken);
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        } else if (!(statusCode != 401 && statusCode != 400 || "".equals(oauthUsername) || "".equals(oauthUserPassword))) {
            this.getPasswordGrantAccessToken(url, trustStorePath, trustStorePassword, oauthUsername, oauthUserPassword, encodedAuth, bodyConsumerKey, bodyConsumerSecret, oauth2Scope);
        } else if (statusCode == 401 || statusCode == 400) {
            this.getClientGrantAccessToken(url, trustStorePath, trustStorePassword, encodedAuth);
        } else {
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        }
    }

    public void getClientGrantAccessToken(String url, String trustStorePath, String trustStorePassword, String encodedAuth) {
        HashMap<String, String> refreshTokenBody = new HashMap<String, String>();
        refreshTokenBody.put("grant_type", "client_credentials");
        OkHttpClient client = HttpsClient.getOkHttpClient(trustStorePath, trustStorePassword);
        HashMap<String, String> headers = HttpsClient.setHeaders(encodedAuth);
        List<String> response = HttpRequest.getResponse(url, encodedAuth, HttpsClient.getPayload(refreshTokenBody), client, headers);
        client.dispatcher().executorService().shutdown();
        JSONObject jsonObject = new JSONObject(response.get(1));
        int statusCode = Integer.parseInt(response.get(0));
        if (statusCode == 200) {
            String accessToken = jsonObject.getString("access_token");
            this.accessTokenCache.setAccessToken(encodedAuth, "Bearer " + accessToken);
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        } else {
            this.accessTokenCache.setResponseCode(encodedAuth, statusCode);
        }
    }
}

