/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.table.Table;
import io.siddhi.extension.io.http.metrics.SourceMetrics;
import io.siddhi.extension.io.http.source.HttpAuthenticator;
import io.siddhi.extension.io.http.source.HttpWebSubResponseProcessor;
import io.siddhi.extension.io.http.source.HttpWorkerThread;
import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorRuntimeException;
import io.siddhi.extension.io.http.source.util.HttpSourceUtil;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpSourceListener {
    private static final Logger logger = LoggerFactory.getLogger(HttpSourceListener.class);
    private static final char QUERY_PARAMS_IDENTIFIER = '_';
    private static final String QUERY_PARAMS_CONTAINING_PROPERTY = "TO";
    private static final char QUERY_PARAMS_SEPARATOR = '&';
    private static final String QUERY_PARAMS_SPLITTER_FROM_URLSTRING = "\\?";
    private static final char QUERY_PARAMS_KEY_AND_VALUE_SEPARATOR = '=';
    protected ExecutorService executorService;
    protected boolean paused;
    protected ReentrantLock lock;
    protected Condition condition;
    protected String url;
    protected Boolean isAuthEnabled;
    protected SourceEventListener sourceEventListener;
    protected String[] requestedTransportPropertyNames;
    protected SourceMetrics metrics;
    protected String urlString;
    boolean isWebSub = false;
    Table table;
    String hubId;
    private String siddhiAppName;
    private SiddhiAppContext siddhiAppContext;
    private List<String> topics;

    protected HttpSourceListener(int workerThread, String url, Boolean auth, SourceEventListener sourceEventListener, String[] requestedTransportPropertyNames, String siddhiAppName, SourceMetrics metrics) {
        this.executorService = Executors.newFixedThreadPool(workerThread);
        this.siddhiAppName = siddhiAppName;
        this.paused = false;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.url = url;
        this.isAuthEnabled = auth;
        this.sourceEventListener = sourceEventListener;
        this.requestedTransportPropertyNames = requestedTransportPropertyNames;
        this.metrics = metrics;
    }

    protected HttpSourceListener(int workerThread, String url, Boolean auth, SourceEventListener sourceEventListener, String[] requestedTransportPropertyNames, String siddhiAppName, SourceMetrics metrics, Table table, String hubId, SiddhiAppContext siddhiAppContext, List<String> topics) {
        this.executorService = Executors.newFixedThreadPool(workerThread);
        this.siddhiAppName = siddhiAppName;
        this.paused = false;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.url = url;
        this.isAuthEnabled = auth;
        this.sourceEventListener = sourceEventListener;
        this.requestedTransportPropertyNames = requestedTransportPropertyNames;
        this.metrics = metrics;
        this.isWebSub = true;
        this.table = table;
        this.hubId = hubId;
        this.siddhiAppContext = siddhiAppContext;
        this.topics = topics;
    }

    public String getSiddhiAppName() {
        return this.siddhiAppName;
    }

    protected void send(HttpCarbonMessage carbonMessage) {
        if (this.paused) {
            this.lock.lock();
            try {
                while (this.paused) {
                    this.condition.await();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                if (this.metrics != null) {
                    this.metrics.getTotalHttpErrorsMetric().inc();
                }
                logger.error("Thread interrupted while pausing ", (Throwable)ie);
                HttpSourceUtil.handleCallback(carbonMessage, 500);
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.isAuthEnabled.booleanValue() && !HttpAuthenticator.authenticate(carbonMessage)) {
            if (this.metrics != null) {
                this.metrics.getTotalHttpErrorsMetric().inc();
            }
            throw new HttpSourceAdaptorRuntimeException(carbonMessage, "Authorisation fails", 401);
        }
        String[] trpProperties = new String[this.requestedTransportPropertyNames.length];
        this.populateTransportHeaders(carbonMessage, trpProperties);
        this.populateTransportProperties(carbonMessage, trpProperties);
        if (this.isWebSub) {
            this.executorService.execute(new HttpWebSubResponseProcessor(carbonMessage, this.sourceEventListener, this.sourceEventListener.getStreamDefinition().toString(), trpProperties, this.metrics, this.table, this.hubId, this.siddhiAppContext, this.topics));
        } else {
            this.executorService.execute(new HttpWorkerThread(carbonMessage, this.sourceEventListener, this.sourceEventListener.getStreamDefinition().toString(), trpProperties, this.metrics));
        }
    }

    protected void populateTransportHeaders(HttpCarbonMessage carbonMessage, String[] properties) {
        if (this.requestedTransportPropertyNames.length > 0) {
            int i = 0;
            for (String property : this.requestedTransportPropertyNames) {
                String value = carbonMessage.getHeader(property);
                if (value != null) {
                    properties[i] = value;
                }
                ++i;
            }
        }
    }

    protected void populateTransportProperties(HttpCarbonMessage carbonMessage, String[] properties) {
        if (this.requestedTransportPropertyNames.length > 0) {
            int i = 0;
            for (String property : this.requestedTransportPropertyNames) {
                if (property.startsWith(String.valueOf('_'))) {
                    String[] temp2;
                    String[] param = property.split(String.valueOf('_'), -2);
                    this.urlString = carbonMessage.getProperty(QUERY_PARAMS_CONTAINING_PROPERTY).toString();
                    String[] temp1 = this.urlString.split(QUERY_PARAMS_SPLITTER_FROM_URLSTRING, -2);
                    for (String temp3 : temp2 = temp1[1].split(String.valueOf('&'), -2)) {
                        String[] temp4 = temp3.split(String.valueOf('='), -2);
                        if (!temp4[0].equals(param[1])) continue;
                        properties[i] = temp4[1];
                    }
                } else {
                    Object value = carbonMessage.getProperty(property);
                    if (value != null) {
                        properties[i] = String.valueOf(value);
                    }
                }
                ++i;
            }
        }
    }

    boolean isRunning() {
        return !this.paused;
    }

    boolean isPaused() {
        return this.paused;
    }

    void pause() {
        this.lock.lock();
        try {
            this.paused = true;
            logger.info("Event input has paused for " + this.url);
        }
        finally {
            this.lock.unlock();
        }
    }

    void resume() {
        this.lock.lock();
        try {
            this.paused = false;
            logger.info("Event input has resume for " + this.url);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void disconnect() {
        this.executorService.shutdown();
    }
}

