/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.extension.io.http.metrics.SourceMetrics;
import io.siddhi.extension.io.http.source.ConnectorStartupSynchronizer;
import io.siddhi.extension.io.http.source.HTTPSyncConnectorListener;
import io.siddhi.extension.io.http.source.HttpConnectorPortBindingListener;
import io.siddhi.extension.io.http.source.HttpConnectorRegistry;
import io.siddhi.extension.io.http.source.HttpSourceListener;
import io.siddhi.extension.io.http.source.HttpSyncSourceListener;
import io.siddhi.extension.io.http.source.util.HttpSourceUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;

public class HttpSyncConnectorRegistry
extends HttpConnectorRegistry {
    private static HttpSyncConnectorRegistry instance = new HttpSyncConnectorRegistry();
    private Map<String, HttpSyncSourceListener> sourceListenersMap = new ConcurrentHashMap<String, HttpSyncSourceListener>();

    private HttpSyncConnectorRegistry() {
    }

    public static HttpSyncConnectorRegistry getInstance() {
        return instance;
    }

    protected Map<String, HttpSyncSourceListener> getSyncSourceListenersMap() {
        return this.sourceListenersMap;
    }

    protected void registerSourceListener(SourceEventListener sourceEventListener, String listenerUrl, int workerThread, Boolean isAuth, String[] requestedTransportPropertyNames, String sourceId, String siddhiAppName, SourceMetrics metrics, boolean isWebSub) {
        String listenerKey = HttpSourceUtil.getSourceListenerKey(listenerUrl, metrics);
        HttpSourceListener httpSourceListener = this.sourceListenersMap.putIfAbsent(listenerKey, new HttpSyncSourceListener(workerThread, listenerUrl, isAuth, sourceEventListener, requestedTransportPropertyNames, sourceId, siddhiAppName, metrics, isWebSub));
        if (httpSourceListener != null) {
            throw new SiddhiAppCreationException("Listener URL " + listenerUrl + " already connected");
        }
    }

    @Override
    protected void unregisterSourceListener(String listenerUrl, String siddhiAppName, SourceMetrics metrics) {
        String key = HttpSourceUtil.getSourceListenerKey(listenerUrl, metrics);
        HttpSourceListener httpSourceListener = this.sourceListenersMap.get(key);
        if (httpSourceListener != null && httpSourceListener.getSiddhiAppName().equals(siddhiAppName)) {
            this.sourceListenersMap.remove(key);
            httpSourceListener.disconnect();
        }
    }

    @Override
    protected synchronized void initBootstrapConfigIfFirst(ConfigReader sourceConfigReader) {
        if (this.sourceListenersMap.isEmpty() && this.httpConnectorFactory == null) {
            String bootstrapWorker = sourceConfigReader.readConfig("serverBootstrapWorkerGroupSize", "");
            String bootstrapBoss = sourceConfigReader.readConfig("serverBootstrapBossGroupSize", "");
            String bootstrapClient = sourceConfigReader.readConfig("serverBootstrapClientGroupSize", "");
            this.httpConnectorFactory = !"".equals(bootstrapBoss) && !"".equals(bootstrapWorker) ? (!"".equals(bootstrapClient) ? new DefaultHttpWsConnectorFactory(Integer.parseInt(bootstrapBoss), Integer.parseInt(bootstrapWorker), Integer.parseInt(bootstrapClient)) : new DefaultHttpWsConnectorFactory(Integer.parseInt(bootstrapBoss), Integer.parseInt(bootstrapWorker), Integer.parseInt(bootstrapWorker))) : new DefaultHttpWsConnectorFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearBootstrapConfigIfLast() {
        HttpSyncConnectorRegistry httpSyncConnectorRegistry = this;
        synchronized (httpSyncConnectorRegistry) {
            if (this.sourceListenersMap.isEmpty() && this.httpConnectorFactory != null) {
                this.httpConnectorFactory.shutdownNow();
                this.httpConnectorFactory = null;
            }
        }
    }

    @Override
    protected void setConnectorListeners(ServerConnectorFuture connectorFuture, String serverConnectorId, ConnectorStartupSynchronizer startupSyncer, SourceMetrics metrics) {
        connectorFuture.setHttpConnectorListener(new HTTPSyncConnectorListener());
        connectorFuture.setPortBindingEventListener(new HttpConnectorPortBindingListener(startupSyncer, serverConnectorId, metrics));
    }
}

