/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.extension.io.http.metrics.SourceMetrics;
import io.siddhi.extension.io.http.source.HttpAuthenticator;
import io.siddhi.extension.io.http.source.HttpSourceListener;
import io.siddhi.extension.io.http.source.HttpSyncWorkerThread;
import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorRuntimeException;
import io.siddhi.extension.io.http.source.util.HttpSourceUtil;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpSyncSourceListener
extends HttpSourceListener {
    private static final Logger logger = LoggerFactory.getLogger(HttpSyncSourceListener.class);
    private String sourceId;

    protected HttpSyncSourceListener(int workerThread, String url, Boolean auth, SourceEventListener sourceEventListener, String[] requestedTransportPropertyNames, String sourceId, String siddhiAppName, SourceMetrics metrics, boolean isWebSub) {
        super(workerThread, url, auth, sourceEventListener, requestedTransportPropertyNames, siddhiAppName, metrics);
        this.sourceId = sourceId;
    }

    @Override
    protected void send(HttpCarbonMessage carbonMessage) {
        if (this.paused) {
            this.lock.lock();
            try {
                while (this.paused) {
                    this.condition.await();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                if (this.metrics != null) {
                    this.metrics.getTotalHttpErrorsMetric().inc();
                }
                logger.error("Thread interrupted while pausing ", (Throwable)ie);
                HttpSourceUtil.handleCallback(carbonMessage, 500);
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.isAuthEnabled.booleanValue() && !HttpAuthenticator.authenticate(carbonMessage)) {
            if (this.metrics != null) {
                this.metrics.getTotalHttpErrorsMetric().inc();
            }
            throw new HttpSourceAdaptorRuntimeException(carbonMessage, "Authorisation fails", 401);
        }
        String[] trpProperties = new String[this.requestedTransportPropertyNames.length];
        this.populateTransportHeaders(carbonMessage, trpProperties);
        this.populateTransportProperties(carbonMessage, trpProperties);
        String messageId = UUID.randomUUID().toString();
        this.populateTransportProperties(trpProperties, messageId);
        this.executorService.execute(new HttpSyncWorkerThread(carbonMessage, this.sourceEventListener, this.sourceEventListener.getStreamDefinition().toString(), trpProperties, this.sourceId, messageId, this.metrics));
    }

    private void populateTransportProperties(String[] properties, String messageId) {
        if (this.requestedTransportPropertyNames.length > 0) {
            int i = 0;
            for (String property : this.requestedTransportPropertyNames) {
                if ("messageId".equalsIgnoreCase(property)) {
                    properties[i] = messageId;
                    break;
                }
                ++i;
            }
        }
    }
}

