/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.table.CompiledUpdateSet;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.AddingStreamEventExtractor;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.extension.io.http.metrics.SourceMetrics;
import io.siddhi.extension.io.http.source.util.HttpSourceUtil;
import io.siddhi.extension.io.http.util.HttpIoUtil;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.execution.query.output.stream.UpdateSet;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public class HttpWebSubResponseProcessor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HttpWebSubResponseProcessor.class);
    private final HttpCarbonMessage carbonMessage;
    private final SourceEventListener sourceEventListener;
    private final String sourceID;
    private final Object[] trpProperties;
    private final SourceMetrics metrics;
    private final Table table;
    private final String hubId;
    private final SiddhiQueryContext siddhiQueryContext;
    private final Map<String, Table> tableMap;
    private final AddingStreamEventExtractor addingStreamEventExtractor;
    private final List<String> topics;
    private CompiledCondition updateCompileCondition;
    private UpdateSet updateSet;
    private CompiledUpdateSet compiledUpdateSet;
    private CompiledCondition deleteCompileCondition;

    HttpWebSubResponseProcessor(HttpCarbonMessage cMessage, SourceEventListener sourceEventListener, String sourceID, String[] trpProperties, SourceMetrics metrics, Table table, String hubId, SiddhiAppContext siddhiAppContext, List<String> topics) {
        this.carbonMessage = cMessage;
        this.sourceEventListener = sourceEventListener;
        this.sourceID = sourceID;
        this.trpProperties = trpProperties;
        this.metrics = metrics;
        this.table = table;
        this.hubId = hubId;
        this.siddhiQueryContext = new SiddhiQueryContext(siddhiAppContext, sourceID);
        HashMap<String, Table> tableMap = new HashMap<String, Table>();
        tableMap.put(table.getTableDefinition().getId(), table);
        this.tableMap = tableMap;
        this.createTableUpdateResources();
        this.deleteCompileCondition = HttpIoUtil.createTableDeleteResource(tableMap, table.getTableDefinition().getId(), this.siddhiQueryContext);
        this.addingStreamEventExtractor = new AddingStreamEventExtractor(0);
        this.topics = topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String payload;
        block29: {
            StreamEvent complexEvent;
            List attributeList;
            ArrayList<Object> event;
            Map<String, Object> payloadMap;
            block31: {
                Iterator iterator;
                block30: {
                    BufferedReader buf = new BufferedReader(new InputStreamReader(new HttpMessageDataStreamer(this.carbonMessage).getInputStream(), Charset.defaultCharset()));
                    try {
                        payload = buf.lines().collect(Collectors.joining("\n"));
                        if (!payload.equals("")) {
                            boolean isRequestValid;
                            if (this.metrics != null) {
                                this.metrics.getTotalReadsMetric().inc();
                                this.metrics.getTotalHttpReadsMetric().inc();
                                this.metrics.getRequestSizeMetric().inc(HttpSourceUtil.getByteSize(payload));
                                this.metrics.setLastEventTime(System.currentTimeMillis());
                            }
                            if (!(isRequestValid = HttpIoUtil.validateAndVerifySubscriptionRequest(this.carbonMessage, payloadMap = this.processPayload(payload), payload, this.topics))) break block29;
                            event = new ArrayList<Object>();
                            attributeList = this.table.getTableDefinition().getAttributeList();
                            if (payloadMap.get("mode").toString().equalsIgnoreCase("subscribe")) {
                                iterator = attributeList.iterator();
                                break block30;
                            }
                            event.add(payloadMap.get("callback"));
                            event.add(payloadMap.get("topic"));
                            break block31;
                        }
                        if (this.metrics != null) {
                            this.metrics.getTotalHttpErrorsMetric().inc();
                        }
                        HttpSourceUtil.handleCallback(this.carbonMessage, 405);
                        if (!logger.isDebugEnabled()) return;
                        logger.debug("Empty payload event, hence dropping the event chunk at source " + this.sourceID);
                        return;
                    }
                    catch (UnsupportedEncodingException | RuntimeException e) {
                        HttpIoUtil.handleFailure(this.carbonMessage, null, 500, e.getMessage());
                        logger.error("Error occurred while processing the payload ", (Throwable)e);
                        return;
                    }
                    finally {
                        try {
                            buf.close();
                        }
                        catch (IOException e) {
                            if (this.metrics != null) {
                                this.metrics.getTotalHttpErrorsMetric().inc();
                            }
                            logger.error("Error occurred when closing the byte buffer in source " + this.sourceID, (Throwable)e);
                        }
                        finally {
                            this.carbonMessage.waitAndReleaseAllEntities();
                        }
                    }
                }
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    if (attribute.getName().equalsIgnoreCase("callback")) {
                        event.add(URLDecoder.decode(payloadMap.get(attribute.getName()).toString(), StandardCharsets.UTF_8.name()));
                        continue;
                    }
                    if (attribute.getName().equals("id")) {
                        event.add(this.hubId);
                        continue;
                    }
                    if (attribute.getName().equals("timestamp")) {
                        event.add(System.currentTimeMillis());
                        continue;
                    }
                    event.add(this.processAndGet(payloadMap.get(attribute.getName()).toString(), attribute));
                }
            }
            ComplexEventChunk eventChunk = new ComplexEventChunk();
            if (payloadMap.get("mode").toString().equalsIgnoreCase("subscribe")) {
                complexEvent = new StreamEvent(0, 0, attributeList.size());
                StateEvent stateEvent = new StateEvent(1, 0);
                complexEvent.setOutputData(event.toArray());
                stateEvent.addEvent(0, complexEvent);
                stateEvent.setType(ComplexEvent.Type.CURRENT);
                eventChunk.add((ComplexEvent)stateEvent);
                this.table.updateOrAddEvents(eventChunk, this.updateCompileCondition, this.compiledUpdateSet, this.addingStreamEventExtractor, 1);
            } else {
                complexEvent = new StreamEvent(0, 0, 2);
                StateEvent stateEvent = new StateEvent(1, 2);
                complexEvent.setOutputData(event.toArray());
                stateEvent.addEvent(0, complexEvent);
                stateEvent.setType(ComplexEvent.Type.CURRENT);
                eventChunk.add((ComplexEvent)stateEvent);
                this.table.deleteEvents(eventChunk, this.deleteCompileCondition, 1);
            }
            logger.debug("Incoming Request accepted for callback: " + payloadMap.get("callback") + ". topic: " + payloadMap.get("topic") + " mode: " + payloadMap.get("mode"));
            HttpIoUtil.notifyWebSubSink(this.hubId);
            HttpIoUtil.handleResponse(this.carbonMessage, HttpIoUtil.createResponseMessageForWebSub(this.carbonMessage));
            this.sourceEventListener.onEvent(payloadMap, this.trpProperties);
        }
        if (!logger.isDebugEnabled()) return;
        logger.debug("Submitted Event " + payload + " Stream");
    }

    public Map<String, Object> processPayload(String payload) {
        String decodedPayload = QueryStringDecoder.decodeComponent(payload, StandardCharsets.UTF_8);
        String[] parametersArray = decodedPayload.split("&");
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (parametersArray.length > 0) {
            for (String parameterPair : parametersArray) {
                String[] parameterPairArray = parameterPair.split("=");
                if (parameterPairArray.length != 2) continue;
                parameterMap.put(parameterPairArray[0].replace("hub.", "").trim(), parameterPairArray[1].trim());
            }
        }
        if (!parameterMap.containsKey("secret")) {
            parameterMap.put("secret", "");
        } else if (!parameterMap.containsKey("lease_seconds")) {
            parameterMap.put("lease_seconds", 86400);
        }
        return parameterMap;
    }

    private Object processAndGet(String value, Attribute attribute) {
        switch (attribute.getType()) {
            default: {
                return value != null ? value : "N/A";
            }
            case INT: {
                return Integer.parseInt(value);
            }
            case BOOL: {
                return Boolean.parseBoolean(value);
            }
            case LONG: {
                if (attribute.getName().equalsIgnoreCase("lease_seconds")) {
                    return Long.parseLong(value);
                }
                return Long.parseLong(value);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case DOUBLE: 
        }
        return Double.parseDouble(value);
    }

    private void createTableUpdateResources() {
        Expression condition = HttpIoUtil.generateFilterConditionForWebSubHub(this.table);
        MetaStateEvent tableUpdateMetaStateEvent = new MetaStateEvent(2);
        MetaStreamEvent tableMetaStreamEvent = new MetaStreamEvent();
        MetaStreamEvent inputStreamMetaStreamEvent = new MetaStreamEvent();
        TableDefinition inputTableDefinition = TableDefinition.id((String)"");
        this.table.getTableDefinition().getAttributeList().forEach(attribute -> inputTableDefinition.attribute(attribute.getName(), attribute.getType()));
        inputStreamMetaStreamEvent.addInputDefinition((AbstractDefinition)inputTableDefinition);
        tableMetaStreamEvent.addInputDefinition((AbstractDefinition)this.table.getTableDefinition());
        this.table.getTableDefinition().getAttributeList().forEach(arg_0 -> ((MetaStreamEvent)tableMetaStreamEvent).addOutputData(arg_0));
        this.table.getTableDefinition().getAttributeList().forEach(arg_0 -> ((MetaStreamEvent)inputStreamMetaStreamEvent).addOutputData(arg_0));
        tableMetaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        inputStreamMetaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        tableUpdateMetaStateEvent.addEvent(inputStreamMetaStreamEvent);
        tableUpdateMetaStateEvent.addEvent(tableMetaStreamEvent);
        MatchingMetaInfoHolder matchingMetaInfoHolder = new MatchingMetaInfoHolder(tableUpdateMetaStateEvent, 0, 1, (AbstractDefinition)inputTableDefinition, (AbstractDefinition)this.table.getTableDefinition(), 0);
        this.updateCompileCondition = this.table.compileCondition(condition, matchingMetaInfoHolder, null, this.tableMap, this.siddhiQueryContext);
        this.updateSet = new UpdateSet();
        this.table.getTableDefinition().getAttributeList().forEach(attribute -> this.updateSet.set(new Variable(attribute.getName()), (Expression)new Variable(attribute.getName())));
        this.compiledUpdateSet = this.table.compileUpdateSet(this.updateSet, matchingMetaInfoHolder, null, this.tableMap, this.siddhiQueryContext);
    }
}

