/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.extension.io.http.metrics.SourceMetrics;
import io.siddhi.extension.io.http.source.SSEResponseConnectorListener;
import io.siddhi.extension.io.http.source.SSESource;
import io.siddhi.extension.io.http.util.HTTPSourceRegistry;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SSEResponseListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(SSEResponseListener.class);
    private String streamId;
    private CountDownLatch latch;
    private SSESource source;
    private SourceMetrics metrics;

    public SSEResponseListener(SSESource source, String streamId, CountDownLatch latch, SourceMetrics metrics) {
        this.streamId = streamId;
        this.latch = latch;
        this.source = source;
        this.metrics = metrics;
    }

    @Override
    public void onMessage(HttpCarbonMessage carbonMessage) {
        SSESource responseSource;
        carbonMessage.setProperty("__is_downloadable_content", false);
        if (this.latch != null) {
            this.latch.countDown();
        }
        if ((responseSource = HTTPSourceRegistry.findAndGetSSESource(this.streamId)) != null) {
            SSEResponseConnectorListener responseConnectorListener = responseSource.getConnectorListener();
            responseConnectorListener.onMessage(carbonMessage);
        } else {
            log.error("No sse source is registered for the stream '" + this.streamId + "'. Hence dropping the response message.");
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof IOException) {
            this.source.createClientConnector();
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
    }
}

