/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.extension.io.http.source.SSEResponseConnectorListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class SSESourceConnectorRegistry {
    private static SSESourceConnectorRegistry instance = new SSESourceConnectorRegistry();
    private Map<String, SSEResponseConnectorListener> sourceListenersMap = new ConcurrentHashMap<String, SSEResponseConnectorListener>();

    private SSESourceConnectorRegistry() {
    }

    static SSESourceConnectorRegistry getInstance() {
        return instance;
    }

    Map<String, SSEResponseConnectorListener> getSourceListenersMap() {
        return this.sourceListenersMap;
    }

    void registerSourceListener(SSEResponseConnectorListener httpSSEResponseConnectorListener, String streamId) {
        SSEResponseConnectorListener sourceListener = this.sourceListenersMap.putIfAbsent(streamId, httpSSEResponseConnectorListener);
        if (sourceListener != null) {
            throw new SiddhiAppCreationException("There is a connection already established for the sse source with stream id : '" + streamId + "'.");
        }
    }

    void unregisterSourceListener(String streamId, String siddhiAppName) {
        SSEResponseConnectorListener httpSourceListener = this.sourceListenersMap.get(streamId);
        if (httpSourceListener != null && httpSourceListener.getSiddhiAppName().equals(siddhiAppName)) {
            this.sourceListenersMap.remove(streamId);
            httpSourceListener.disconnect();
        }
    }
}

