/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.source.internal;

import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorException;
import io.siddhi.extension.io.http.source.internal.HttpIODataHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;

@Component(name="io.siddhi.extension.io.http.source.internal.ServiceComponent", service={ServiceComponent.class}, immediate=true)
public class ServiceComponent {
    private static final Logger log = LogManager.getLogger(ServiceComponent.class);

    @Activate
    protected void start(BundleContext bundleContext) throws Exception {
        try {
            HttpIODataHolder.getInstance().setBundleContext(bundleContext);
        }
        catch (Throwable throwable) {
            log.error("Error occurred when initializing HTTP IO service component.", throwable);
            throw new HttpSourceAdaptorException("Error occurred when initializing HTTP IO service component.", throwable);
        }
    }

    @Deactivate
    protected void stop() throws Exception {
        HttpIODataHolder.getInstance().setBundleContext(null);
    }

    @Reference(name="org.wso2.carbon.analytics.idp.client.core.api.IdPClient", service=IdPClient.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterIdP")
    protected void registerIdP(IdPClient client) {
        HttpIODataHolder.getInstance().setClient(client);
    }

    protected void unregisterIdP(IdPClient client) {
        HttpIODataHolder.getInstance().setClient(null);
    }
}

