/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.http.util;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.extension.io.http.source.exception.HttpSourceAdaptorRuntimeException;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.condition.And;
import io.siddhi.query.api.expression.condition.Compare;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.transport.http.netty.contract.config.Parameter;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.PoolConfiguration;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpIoUtil {
    private static final Logger log = LogManager.getLogger(HttpIoUtil.class);
    private static String clientStoreFile;
    private static String clientStorePass;
    private static ConfigReader configReader;
    private static PoolConfiguration connectionPoolConfiguration;
    private static DefaultHttpWsConnectorFactory httpConnectorFactory;
    private static Map<String, Boolean> webSuHubSubscriptionUpdate;

    public static void handleResponse(HttpCarbonMessage requestMsg, HttpCarbonMessage responseMsg) {
        try {
            requestMsg.respond(responseMsg);
        }
        catch (ServerConnectorException e) {
            throw new HttpSourceAdaptorRuntimeException("Error occurred during response", e);
        }
    }

    public static void handleFailure(HttpCarbonMessage requestMessage, HttpSourceAdaptorRuntimeException ex, Integer code, String payload) {
        String responsePayload;
        int statusCode = code == null ? 500 : code;
        String string = responsePayload = payload != null ? payload : "";
        if (statusCode == 404 && ex != null) {
            responsePayload = ex.getMessage();
            log.error(responsePayload, (Throwable)ex);
        }
        HttpIoUtil.handleResponse(requestMessage, HttpIoUtil.createErrorMessage(responsePayload, statusCode));
    }

    private static HttpCarbonMessage createErrorMessage(String responseValue, int statusCode) {
        HttpCarbonMessage response = HttpIoUtil.createHttpCarbonMessage();
        if (responseValue != null) {
            byte[] array;
            try {
                array = responseValue.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpSourceAdaptorRuntimeException("Error sending response.", e);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(array.length);
            byteBuffer.put(array);
            response.setHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(array.length));
            byteBuffer.flip();
            response.addHttpContent(new DefaultLastHttpContent(Unpooled.wrappedBuffer(byteBuffer)));
        }
        response.setHttpStatusCode(statusCode);
        response.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        return response;
    }

    public static HttpCarbonMessage createOptionsResponseMessage(HttpCarbonMessage request) {
        HttpCarbonMessage response = HttpIoUtil.createHttpCarbonMessage();
        response.addHttpContent(new DefaultLastHttpContent(Unpooled.wrappedBuffer(ByteBuffer.allocate(0))));
        response.setHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(0));
        response.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), request.getHeader(HttpHeaderNames.ORIGIN.toString()));
        response.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), "POST");
        response.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString(), String.format("%s,%s,%s,%s,%s", HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderNames.USER_AGENT.toString(), HttpHeaderNames.ORIGIN.toString(), HttpHeaderNames.REFERER.toString(), HttpHeaderNames.ACCEPT.toString()));
        response.setHttpStatusCode(Integer.parseInt("200"));
        response.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        return response;
    }

    public static HttpCarbonMessage createResponseMessageForWebSub(HttpCarbonMessage request) {
        HttpCarbonMessage response = HttpIoUtil.createHttpCarbonMessage();
        response.addHttpContent(new DefaultLastHttpContent(Unpooled.wrappedBuffer(ByteBuffer.allocate(0))));
        response.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), request.getHeaders().contains(HttpHeaderNames.ORIGIN.toString()) ? request.getHeader(HttpHeaderNames.ORIGIN.toString()) : "*");
        response.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), "POST");
        response.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString(), String.format("%s,%s,%s,%s,%s", HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderNames.USER_AGENT.toString(), HttpHeaderNames.ORIGIN.toString(), HttpHeaderNames.REFERER.toString(), HttpHeaderNames.ACCEPT.toString()));
        response.setHttpStatusCode(202);
        response.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        return response;
    }

    public static HttpCarbonMessage createHttpCarbonMessage() {
        HttpCarbonMessage httpCarbonMessage = new HttpCarbonMessage(new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
        return httpCarbonMessage;
    }

    public static List<Parameter> populateParameters(String parameterList) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (!"".equals(parameterList.trim())) {
            String[] valueList = parameterList.trim().substring(1, parameterList.length() - 1).split("','");
            Arrays.stream(valueList).forEach(valueEntry -> {
                Parameter parameter = new Parameter();
                String[] entry = valueEntry.split(":");
                if (entry.length == 2) {
                    parameter.setName(entry[0]);
                    parameter.setValue(entry[1]);
                    parameters.add(parameter);
                } else {
                    log.error("Bootstrap configuration is not in expected format please insert them as 'key1:val1','key2:val2' format in http source.");
                }
            });
        }
        return parameters;
    }

    public static Map<String, String> populateParameterMap(String[] valueList) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Arrays.stream(valueList).forEach(valueEntry -> {
            String[] entry = valueEntry.split(":");
            if (entry.length == 2) {
                parameterMap.put(entry[0], entry[1]);
            } else {
                log.error("Configuration parameter '" + valueEntry + "' is not in expected format. Please insert them as 'key:val' format");
            }
        });
        return parameterMap;
    }

    public static boolean validateAndVerifySubscriptionRequest(HttpCarbonMessage carbonMessage, Map<String, Object> parameterMap, String decodedPayload, List<String> topics) {
        HashMap<String, Object> responsePayloadMap = new HashMap<String, Object>();
        if (!(parameterMap.containsKey("callback") && parameterMap.containsKey("mode") && parameterMap.containsKey("topic"))) {
            int responseCode = 400;
            responsePayloadMap.put("mode", "denied");
            responsePayloadMap.put("reason", "Subscription request must contains hub.callback, hub.mode and hub.topic parameters. But only found:" + decodedPayload);
            responsePayloadMap.put("topic", parameterMap.get("topic"));
            String responseMessage = responsePayloadMap.keySet().stream().map(key -> key + "=" + responsePayloadMap.get(key)).collect(Collectors.joining("&"));
            HttpIoUtil.handleFailure(carbonMessage, null, responseCode, responseMessage);
            log.error("Subscription request must contains hub.callback, hub.mode and hub.topic parameters.");
            return false;
        }
        if (!topics.contains(parameterMap.get("topic"))) {
            String responseMessage = "Subscription request failed!. Subscribed topic " + parameterMap.get("topic") + " is not found in the WebSub hub ";
            HttpIoUtil.handleFailure(carbonMessage, null, 400, responseMessage);
            log.error(responseMessage);
            return false;
        }
        return true;
    }

    public static void notifyWebSubSink(String hubId) {
        if (webSuHubSubscriptionUpdate.containsKey(hubId)) {
            webSuHubSubscriptionUpdate.replace(hubId, true);
        } else {
            webSuHubSubscriptionUpdate.put(hubId, true);
        }
    }

    public static boolean isWebSubSinkUpdated(String hubId) {
        if (webSuHubSubscriptionUpdate.containsKey(hubId) && webSuHubSubscriptionUpdate.get(hubId).booleanValue()) {
            webSuHubSubscriptionUpdate.replace(hubId, false);
            return true;
        }
        return false;
    }

    public static Expression generateFilterConditionForWebSubHub(Table table) {
        Variable leftOperator = new Variable("callback");
        leftOperator.setStreamId(table.getTableDefinition().getId());
        Compare leftExpression = new Compare((Expression)leftOperator, Compare.Operator.EQUAL, (Expression)new Variable("callback"));
        Variable rightExpresionLeftOperator = new Variable("topic");
        rightExpresionLeftOperator.setStreamId(table.getTableDefinition().getId());
        Compare rightExpression = new Compare((Expression)rightExpresionLeftOperator, Compare.Operator.EQUAL, (Expression)new Variable("topic"));
        return new And((Expression)leftExpression, (Expression)rightExpression);
    }

    public static CompiledCondition createTableDeleteResource(Map<String, Table> tableMap, String tableName, SiddhiQueryContext siddhiQueryContext) {
        Table table = tableMap.get(tableName);
        Expression condition = HttpIoUtil.generateFilterConditionForWebSubHub(table);
        MetaStateEvent metaStateEvent = new MetaStateEvent(2);
        MetaStreamEvent tableMetaStreamEvent = new MetaStreamEvent();
        MetaStreamEvent inputStreamMetaStreamEvent = new MetaStreamEvent();
        tableMetaStreamEvent.addInputDefinition((AbstractDefinition)table.getTableDefinition());
        tableMetaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        TableDefinition tableDefinition = TableDefinition.id((String)"");
        tableDefinition.attribute("callback", Attribute.Type.STRING);
        tableDefinition.attribute("topic", Attribute.Type.STRING);
        inputStreamMetaStreamEvent.addInputDefinition((AbstractDefinition)tableDefinition);
        inputStreamMetaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        metaStateEvent.addEvent(inputStreamMetaStreamEvent);
        metaStateEvent.addEvent(tableMetaStreamEvent);
        MatchingMetaInfoHolder matchingMetaInfoHolder = new MatchingMetaInfoHolder(metaStateEvent, 0, 1, (AbstractDefinition)tableDefinition, (AbstractDefinition)table.getTableDefinition(), 0);
        return table.compileCondition(condition, matchingMetaInfoHolder, null, tableMap, siddhiQueryContext);
    }

    static {
        webSuHubSubscriptionUpdate = new ConcurrentHashMap<String, Boolean>();
    }
}

