/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpClientConnectorListener;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.DefaultOperationStatus;
import org.wso2.transport.http.netty.contractimpl.common.BackPressureHandler;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;
import org.wso2.transport.http.netty.message.ResponseHandle;

public class DefaultHttpResponseFuture
implements HttpResponseFuture {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseFuture.class);
    private HttpConnectorListener httpConnectorListener;
    private HttpClientConnectorListener responseHandleListener;
    private HttpClientConnectorListener promiseAvailabilityListener;
    private HttpConnectorListener pushPromiseListener;
    private ConcurrentHashMap<Integer, HttpConnectorListener> pushResponseListeners;
    private ConcurrentHashMap<Integer, Throwable> pushResponseListenerErrors;
    private BackPressureHandler backPressureHandler;
    private HttpCarbonMessage httpCarbonMessage;
    private ResponseHandle responseHandle;
    private OutboundMsgHolder outboundMsgHolder;
    private Throwable throwable;
    private Throwable responseHandleError;
    private Throwable returnError;
    private Semaphore executionWaitSem;
    private Lock responseLock = new ReentrantLock();
    private Lock responseHandleLock = new ReentrantLock();
    private Lock promiseAvailabilityLock = new ReentrantLock();
    private Lock promiseLock = new ReentrantLock();
    private Lock pushResponseLock = new ReentrantLock();

    public DefaultHttpResponseFuture(OutboundMsgHolder outboundMsgHolder) {
        this.outboundMsgHolder = outboundMsgHolder;
        this.pushResponseListeners = new ConcurrentHashMap();
        this.pushResponseListenerErrors = new ConcurrentHashMap();
    }

    public DefaultHttpResponseFuture() {
        this(null);
    }

    @Override
    public void setHttpConnectorListener(HttpConnectorListener connectorListener) {
        this.responseLock.lock();
        try {
            this.httpConnectorListener = connectorListener;
            if (this.httpCarbonMessage != null) {
                this.notifyHttpListener(this.httpCarbonMessage);
                this.httpCarbonMessage = null;
            }
            if (this.throwable != null) {
                this.notifyHttpListener(this.throwable);
                this.throwable = null;
            }
        }
        finally {
            this.responseLock.unlock();
        }
    }

    @Override
    public void removeHttpListener() {
        this.httpConnectorListener = null;
    }

    @Override
    public void notifyHttpListener(HttpCarbonMessage httpCarbonMessage) {
        this.responseLock.lock();
        try {
            this.httpCarbonMessage = httpCarbonMessage;
            if (this.executionWaitSem != null) {
                this.executionWaitSem.release();
            }
            if (this.httpConnectorListener != null) {
                HttpConnectorListener listener = this.httpConnectorListener;
                this.removeHttpListener();
                listener.onMessage(httpCarbonMessage);
            }
        }
        finally {
            this.responseLock.unlock();
        }
    }

    @Override
    public void notifyHttpListener(Throwable throwable) {
        this.responseLock.lock();
        try {
            if (this.backPressureHandler != null) {
                this.backPressureHandler.getBackPressureObservable().removeListener();
            } else if (this.outboundMsgHolder != null) {
                this.outboundMsgHolder.getBackPressureObservable().removeListener();
            } else {
                LOG.warn("No BackPressureObservable found.");
            }
            this.throwable = throwable;
            this.returnError = throwable;
            if (this.executionWaitSem != null) {
                this.executionWaitSem.release();
            }
            if (this.httpConnectorListener != null) {
                HttpConnectorListener listener = this.httpConnectorListener;
                this.removeHttpListener();
                listener.onError(throwable);
            } else if (this.responseHandleListener != null) {
                HttpClientConnectorListener listener = this.responseHandleListener;
                this.removeResponseHandleListener();
                this.responseHandleError = null;
                listener.onError(throwable);
            }
        }
        finally {
            this.responseLock.unlock();
        }
    }

    @Override
    public HttpResponseFuture sync() throws InterruptedException {
        this.executionWaitSem = new Semaphore(0);
        if (this.httpCarbonMessage == null && this.throwable == null && this.returnError == null) {
            this.executionWaitSem.acquire();
        }
        if (this.httpCarbonMessage != null) {
            this.returnError = null;
            this.httpCarbonMessage = null;
        }
        if (this.throwable != null) {
            this.returnError = this.throwable;
            this.throwable = null;
        }
        return this;
    }

    @Override
    public DefaultOperationStatus getStatus() {
        return this.returnError != null ? new DefaultOperationStatus(this.returnError) : new DefaultOperationStatus(null);
    }

    @Override
    public void resetStatus() {
        this.returnError = null;
    }

    @Override
    public void setBackPressureHandler(BackPressureHandler backPressureHandler) {
        this.backPressureHandler = backPressureHandler;
    }

    @Override
    public void setResponseHandleListener(HttpClientConnectorListener responseHandleListener) {
        this.responseHandleLock.lock();
        try {
            this.responseHandleListener = responseHandleListener;
            if (this.responseHandle != null) {
                this.notifyResponseHandle(this.responseHandle);
                this.responseHandle = null;
            }
            if (this.responseHandleError != null) {
                this.notifyResponseHandle(this.responseHandleError);
                this.responseHandleError = null;
            }
        }
        finally {
            this.responseHandleLock.unlock();
        }
    }

    @Override
    public void removeResponseHandleListener() {
        this.responseHandleListener = null;
    }

    @Override
    public void notifyResponseHandle(ResponseHandle responseHandle) {
        this.responseHandleLock.lock();
        try {
            this.responseHandle = responseHandle;
            if (this.responseHandleListener != null) {
                HttpClientConnectorListener listener = this.responseHandleListener;
                this.removeResponseHandleListener();
                this.responseHandle = null;
                listener.onResponseHandle(responseHandle);
            }
        }
        finally {
            this.responseHandleLock.unlock();
        }
    }

    @Override
    public void notifyResponseHandle(Throwable throwable) {
        this.responseHandleLock.lock();
        try {
            this.responseHandleError = throwable;
            if (this.responseHandleListener != null) {
                HttpClientConnectorListener listener = this.responseHandleListener;
                this.removeResponseHandleListener();
                this.responseHandleError = null;
                listener.onError(throwable);
            }
        }
        finally {
            this.responseHandleLock.unlock();
        }
    }

    @Override
    public void setPromiseAvailabilityListener(HttpClientConnectorListener promiseAvailabilityListener) {
        this.promiseAvailabilityLock.lock();
        try {
            this.promiseAvailabilityListener = promiseAvailabilityListener;
            this.notifyPromiseAvailability();
        }
        finally {
            this.promiseAvailabilityLock.unlock();
        }
    }

    @Override
    public void removePromiseAvailabilityListener() {
        this.promiseAvailabilityListener = null;
    }

    @Override
    public void notifyPromiseAvailability() {
        this.promiseAvailabilityLock.lock();
        try {
            if (this.promiseAvailabilityListener != null) {
                HttpClientConnectorListener listener = this.promiseAvailabilityListener;
                if (this.outboundMsgHolder.hasPromise()) {
                    this.removePromiseAvailabilityListener();
                    listener.onPushPromiseAvailability(true);
                } else if (this.outboundMsgHolder.isAllPromisesReceived()) {
                    this.removePromiseAvailabilityListener();
                    listener.onPushPromiseAvailability(false);
                }
            }
        }
        finally {
            this.promiseAvailabilityLock.unlock();
        }
    }

    @Override
    public void setPushPromiseListener(HttpConnectorListener pushPromiseListener) {
        this.promiseLock.lock();
        try {
            this.pushPromiseListener = pushPromiseListener;
            if (this.outboundMsgHolder.hasPromise()) {
                this.notifyPushPromise();
            }
        }
        finally {
            this.promiseLock.unlock();
        }
    }

    @Override
    public void removePushPromiseListener() {
        this.pushPromiseListener = null;
    }

    @Override
    public void notifyPushPromise() {
        this.promiseLock.lock();
        try {
            if (this.pushPromiseListener != null) {
                HttpConnectorListener listener = this.pushPromiseListener;
                this.removePushPromiseListener();
                listener.onPushPromise(this.outboundMsgHolder.getNextPromise());
            }
        }
        finally {
            this.promiseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPushResponseListener(HttpConnectorListener pushResponseListener, int promiseId) {
        this.pushResponseLock.lock();
        try {
            this.pushResponseListeners.put(promiseId, pushResponseListener);
            HttpCarbonResponse pushResponse = this.outboundMsgHolder.getPushResponse(promiseId);
            if (pushResponse != null) {
                this.notifyPushResponse(promiseId, pushResponse);
            }
            if (this.pushResponseListenerErrors.get(promiseId) != null) {
                this.notifyPushResponse(promiseId, this.pushResponseListenerErrors.get(promiseId));
            }
        }
        finally {
            this.pushResponseLock.unlock();
        }
    }

    @Override
    public void removePushResponseListener(int promisedId) {
        this.pushResponseListeners.remove(promisedId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPushResponse(int streamId, HttpCarbonMessage pushResponse) {
        this.pushResponseLock.lock();
        try {
            HttpConnectorListener listener = this.pushResponseListeners.get(streamId);
            if (listener != null) {
                this.pushResponseListeners.remove(streamId);
                listener.onPushResponse(streamId, pushResponse);
            }
        }
        finally {
            this.pushResponseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPushResponse(int streamId, Throwable throwable) {
        this.pushResponseLock.lock();
        try {
            this.pushResponseListenerErrors.put(streamId, throwable);
            HttpConnectorListener listener = this.pushResponseListeners.get(streamId);
            if (listener != null) {
                this.pushResponseListeners.remove(streamId);
                this.pushResponseListenerErrors.remove(streamId);
                listener.onError(throwable);
            }
        }
        finally {
            this.pushResponseLock.unlock();
        }
    }
}

