/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.HttpServerChannelInitializer;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2ServerChannel;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2ServerTimeoutHandler;
import org.wso2.transport.http.netty.contractimpl.listener.http2.InboundMessageHolder;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ReceivingHeaders;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2Reset;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;
import org.wso2.transport.http.netty.message.ServerRemoteFlowControlListener;

public final class Http2SourceHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(Http2SourceHandler.class);
    private Http2ServerChannel http2ServerChannel = new Http2ServerChannel();
    private ChannelHandlerContext ctx;
    private ServerConnectorFuture serverConnectorFuture;
    private HttpServerChannelInitializer serverChannelInitializer;
    private Http2ConnectionEncoder encoder;
    private Http2Connection conn;
    private String interfaceId;
    private String serverName;
    private String remoteHost;
    private Map<String, GenericObjectPool> targetChannelPool;
    private ServerRemoteFlowControlListener serverRemoteFlowControlListener;
    private SocketAddress remoteAddress;

    Http2SourceHandler(HttpServerChannelInitializer serverChannelInitializer, Http2ConnectionEncoder encoder, String interfaceId, Http2Connection conn, ServerConnectorFuture serverConnectorFuture, String serverName) {
        this.serverChannelInitializer = serverChannelInitializer;
        this.encoder = encoder;
        this.interfaceId = interfaceId;
        this.serverConnectorFuture = serverConnectorFuture;
        this.conn = conn;
        this.serverName = serverName;
        this.targetChannelPool = new ConcurrentHashMap<String, GenericObjectPool>();
        this.setRemoteFlowController();
        this.setDataEventListeners();
    }

    private void setDataEventListeners() {
        long serverTimeout = this.serverChannelInitializer.getSocketIdleTimeout() <= 0L ? 300000L : this.serverChannelInitializer.getSocketIdleTimeout();
        this.http2ServerChannel.addDataEventListener("idleStateHandler", new Http2ServerTimeoutHandler(serverTimeout, this.http2ServerChannel, this.serverConnectorFuture));
    }

    private void setRemoteFlowController() {
        Http2RemoteFlowController remoteFlowController = this.conn.remote().flowController();
        this.serverRemoteFlowControlListener = new ServerRemoteFlowControlListener(remoteFlowController);
        remoteFlowController.listener(this.serverRemoteFlowControlListener);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        this.remoteAddress = ctx.channel().remoteAddress();
        if (this.remoteAddress instanceof InetSocketAddress) {
            this.remoteHost = ((InetSocketAddress)this.remoteAddress).getAddress().toString();
            if (this.remoteHost.startsWith("/")) {
                this.remoteHost = this.remoteHost.substring(1);
            }
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            FullHttpRequest upgradedRequest = ((HttpServerUpgradeHandler.UpgradeEvent)evt).upgradeRequest();
            DefaultHttpRequest httpRequest = new DefaultHttpRequest(new HttpVersion("HTTP/2.0", true), upgradedRequest.method(), upgradedRequest.uri(), upgradedRequest.headers());
            HttpCarbonRequest requestCarbonMessage = Http2StateUtil.setupCarbonRequest(httpRequest, this, 1);
            requestCarbonMessage.addHttpContent(new DefaultLastHttpContent(upgradedRequest.content()));
            requestCarbonMessage.setLastHttpContentArrived();
            InboundMessageHolder inboundMsgHolder = new InboundMessageHolder(requestCarbonMessage);
            if (requestCarbonMessage.getHttp2MessageStateContext() == null) {
                Http2MessageStateContext http2MessageStateContext = new Http2MessageStateContext();
                http2MessageStateContext.setListenerState(new EntityBodyReceived(http2MessageStateContext));
                requestCarbonMessage.setHttp2MessageStateContext(http2MessageStateContext);
            }
            this.http2ServerChannel.getStreamIdRequestMap().put(1, inboundMsgHolder);
            this.http2ServerChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamInit(ctx, 1));
            Http2StateUtil.notifyRequestListener(this, inboundMsgHolder, 1);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Http2Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            Http2MessageStateContext http2MessageStateContext = new Http2MessageStateContext();
            http2MessageStateContext.setListenerState(new ReceivingHeaders(this, http2MessageStateContext));
            http2MessageStateContext.getListenerState().readInboundRequestHeaders(ctx, headersFrame);
        } else if (msg instanceof Http2DataFrame) {
            Http2DataFrame dataFrame = (Http2DataFrame)msg;
            int streamId = dataFrame.getStreamId();
            HttpCarbonMessage sourceReqCMsg = this.http2ServerChannel.getInboundMessage(streamId).getInboundMsg();
            if (sourceReqCMsg == null) {
                dataFrame.getData().release();
            } else {
                sourceReqCMsg.getHttp2MessageStateContext().getListenerState().readInboundRequestBody(this, dataFrame);
            }
        } else if (msg instanceof Http2Reset) {
            this.onResetRead((Http2Reset)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel inactive event received in HTTP2SourceHandler");
        }
        this.destroy();
        this.closeTargetChannels();
        ctx.fireChannelInactive();
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.destroy();
        ctx.fireChannelUnregistered();
    }

    private void destroy() {
        LOG.debug("Inbound request map size {}", (Object)this.http2ServerChannel.getStreamIdRequestMap().size());
        this.http2ServerChannel.getStreamIdRequestMap().forEach((streamId, inboundMessageHolder) -> {
            HttpCarbonMessage inboundMsg = inboundMessageHolder.getInboundMsg();
            LOG.debug("Listener state {}", (Object)inboundMsg.getHttp2MessageStateContext().getListenerState());
            inboundMsg.getHttp2MessageStateContext().getListenerState().handleAbruptChannelClosure(this.serverConnectorFuture, this.getChannelHandlerContext(), inboundMessageHolder.getHttp2OutboundRespListener(), (int)streamId);
            inboundMessageHolder.getHttp2OutboundRespListener().removeDefaultResponseWriter();
            inboundMessageHolder.getHttp2OutboundRespListener().removeBackPressureListener();
        });
        this.http2ServerChannel.getDataEventListeners().forEach(Http2DataEventListener::destroy);
        this.http2ServerChannel.destroy();
    }

    private void closeTargetChannels() {
        this.targetChannelPool.forEach((hostPortKey, genericObjectPool) -> {
            try {
                this.targetChannelPool.remove(hostPortKey).close();
            }
            catch (Exception e) {
                LOG.error("Couldn't close target channel socket connections", (Throwable)e);
            }
        });
    }

    public Map<Integer, InboundMessageHolder> getStreamIdRequestMap() {
        return this.http2ServerChannel.getStreamIdRequestMap();
    }

    private void onResetRead(Http2Reset http2Reset) {
        int streamId = http2Reset.getStreamId();
        InboundMessageHolder inboundMessageHolder = this.http2ServerChannel.getInboundMessage(streamId);
        if (inboundMessageHolder != null) {
            HttpCarbonMessage inboundRequest = inboundMessageHolder.getInboundMsg();
            Util.handleIncompleteMsgOnReset(http2Reset, streamId, inboundRequest);
            LOG.warn("HTTP/2 stream " + streamId + " reset by the remote peer");
        }
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.ctx;
    }

    public ServerConnectorFuture getServerConnectorFuture() {
        return this.serverConnectorFuture;
    }

    public HttpServerChannelInitializer getServerChannelInitializer() {
        return this.serverChannelInitializer;
    }

    public Http2ConnectionEncoder getEncoder() {
        return this.encoder;
    }

    public Http2Connection getConnection() {
        return this.conn;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.targetChannelPool;
    }

    public ChannelHandlerContext getInboundChannelContext() {
        return this.ctx;
    }

    public ServerRemoteFlowControlListener getServerRemoteFlowControlListener() {
        return this.serverRemoteFlowControlListener;
    }

    public Http2ServerChannel getHttp2ServerChannel() {
        return this.http2ServerChannel;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }
}

